/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoutingProfileResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateRoutingProfileResponse> {
    private static final SdkField<String> ROUTING_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRoutingProfileResponse.getter(CreateRoutingProfileResponse::routingProfileArn)).setter(CreateRoutingProfileResponse.setter(Builder::routingProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileArn").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRoutingProfileResponse.getter(CreateRoutingProfileResponse::routingProfileId)).setter(CreateRoutingProfileResponse.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_PROFILE_ARN_FIELD, ROUTING_PROFILE_ID_FIELD));
    private final String routingProfileArn;
    private final String routingProfileId;

    private CreateRoutingProfileResponse(BuilderImpl builder) {
        super(builder);
        this.routingProfileArn = builder.routingProfileArn;
        this.routingProfileId = builder.routingProfileId;
    }

    public String routingProfileArn() {
        return this.routingProfileArn;
    }

    public String routingProfileId() {
        return this.routingProfileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingProfileResponse)) {
            return false;
        }
        CreateRoutingProfileResponse other = (CreateRoutingProfileResponse)((Object)obj);
        return Objects.equals(this.routingProfileArn(), other.routingProfileArn()) && Objects.equals(this.routingProfileId(), other.routingProfileId());
    }

    public String toString() {
        return ToString.builder((String)"CreateRoutingProfileResponse").add("RoutingProfileArn", (Object)this.routingProfileArn()).add("RoutingProfileId", (Object)this.routingProfileId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingProfileArn": {
                return Optional.ofNullable(clazz.cast(this.routingProfileArn()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoutingProfileResponse, T> g) {
        return obj -> g.apply((CreateRoutingProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String routingProfileArn;
        private String routingProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoutingProfileResponse model) {
            super(model);
            this.routingProfileArn(model.routingProfileArn);
            this.routingProfileId(model.routingProfileId);
        }

        public final String getRoutingProfileArn() {
            return this.routingProfileArn;
        }

        @Override
        public final Builder routingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        public final void setRoutingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public CreateRoutingProfileResponse build() {
            return new CreateRoutingProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoutingProfileResponse> {
        public Builder routingProfileArn(String var1);

        public Builder routingProfileId(String var1);
    }
}

