/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContactRecordingRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartContactRecordingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartContactRecordingRequest.getter(StartContactRecordingRequest::instanceId)).setter(StartContactRecordingRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartContactRecordingRequest.getter(StartContactRecordingRequest::contactId)).setter(StartContactRecordingRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartContactRecordingRequest.getter(StartContactRecordingRequest::initialContactId)).setter(StartContactRecordingRequest.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<VoiceRecordingConfiguration> VOICE_RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartContactRecordingRequest.getter(StartContactRecordingRequest::voiceRecordingConfiguration)).setter(StartContactRecordingRequest.setter(Builder::voiceRecordingConfiguration)).constructor(VoiceRecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceRecordingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, INITIAL_CONTACT_ID_FIELD, VOICE_RECORDING_CONFIGURATION_FIELD));
    private final String instanceId;
    private final String contactId;
    private final String initialContactId;
    private final VoiceRecordingConfiguration voiceRecordingConfiguration;

    private StartContactRecordingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.initialContactId = builder.initialContactId;
        this.voiceRecordingConfiguration = builder.voiceRecordingConfiguration;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String contactId() {
        return this.contactId;
    }

    public String initialContactId() {
        return this.initialContactId;
    }

    public VoiceRecordingConfiguration voiceRecordingConfiguration() {
        return this.voiceRecordingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceRecordingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactRecordingRequest)) {
            return false;
        }
        StartContactRecordingRequest other = (StartContactRecordingRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.voiceRecordingConfiguration(), other.voiceRecordingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"StartContactRecordingRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("InitialContactId", (Object)this.initialContactId()).add("VoiceRecordingConfiguration", (Object)this.voiceRecordingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "VoiceRecordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.voiceRecordingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartContactRecordingRequest, T> g) {
        return obj -> g.apply((StartContactRecordingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private String initialContactId;
        private VoiceRecordingConfiguration voiceRecordingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactRecordingRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.initialContactId(model.initialContactId);
            this.voiceRecordingConfiguration(model.voiceRecordingConfiguration);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getContactId() {
            return this.contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        public final VoiceRecordingConfiguration.Builder getVoiceRecordingConfiguration() {
            return this.voiceRecordingConfiguration != null ? this.voiceRecordingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder voiceRecordingConfiguration(VoiceRecordingConfiguration voiceRecordingConfiguration) {
            this.voiceRecordingConfiguration = voiceRecordingConfiguration;
            return this;
        }

        public final void setVoiceRecordingConfiguration(VoiceRecordingConfiguration.BuilderImpl voiceRecordingConfiguration) {
            this.voiceRecordingConfiguration = voiceRecordingConfiguration != null ? voiceRecordingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContactRecordingRequest build() {
            return new StartContactRecordingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContactRecordingRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder initialContactId(String var1);

        public Builder voiceRecordingConfiguration(VoiceRecordingConfiguration var1);

        default public Builder voiceRecordingConfiguration(Consumer<VoiceRecordingConfiguration.Builder> voiceRecordingConfiguration) {
            return this.voiceRecordingConfiguration((VoiceRecordingConfiguration)((VoiceRecordingConfiguration.Builder)VoiceRecordingConfiguration.builder().applyMutation(voiceRecordingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

