/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.SecurityProfileIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserSecurityProfilesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateUserSecurityProfilesRequest> {
    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateUserSecurityProfilesRequest.getter(UpdateUserSecurityProfilesRequest::securityProfileIds)).setter(UpdateUserSecurityProfilesRequest.setter(Builder::securityProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserSecurityProfilesRequest.getter(UpdateUserSecurityProfilesRequest::userId)).setter(UpdateUserSecurityProfilesRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateUserSecurityProfilesRequest.getter(UpdateUserSecurityProfilesRequest::instanceId)).setter(UpdateUserSecurityProfilesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_IDS_FIELD, USER_ID_FIELD, INSTANCE_ID_FIELD));
    private final List<String> securityProfileIds;
    private final String userId;
    private final String instanceId;

    private UpdateUserSecurityProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileIds = builder.securityProfileIds;
        this.userId = builder.userId;
        this.instanceId = builder.instanceId;
    }

    public boolean hasSecurityProfileIds() {
        return this.securityProfileIds != null && !(this.securityProfileIds instanceof SdkAutoConstructList);
    }

    public List<String> securityProfileIds() {
        return this.securityProfileIds;
    }

    public String userId() {
        return this.userId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserSecurityProfilesRequest)) {
            return false;
        }
        UpdateUserSecurityProfilesRequest other = (UpdateUserSecurityProfilesRequest)((Object)obj);
        return Objects.equals(this.securityProfileIds(), other.securityProfileIds()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserSecurityProfilesRequest").add("SecurityProfileIds", this.securityProfileIds()).add("UserId", (Object)this.userId()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityProfileIds": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIds()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserSecurityProfilesRequest, T> g) {
        return obj -> g.apply((UpdateUserSecurityProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();
        private String userId;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserSecurityProfilesRequest model) {
            super(model);
            this.securityProfileIds(model.securityProfileIds);
            this.userId(model.userId);
            this.instanceId(model.instanceId);
        }

        public final Collection<String> getSecurityProfileIds() {
            return this.securityProfileIds;
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String ... securityProfileIds) {
            this.securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserSecurityProfilesRequest build() {
            return new UpdateUserSecurityProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserSecurityProfilesRequest> {
        public Builder securityProfileIds(Collection<String> var1);

        public Builder securityProfileIds(String ... var1);

        public Builder userId(String var1);

        public Builder instanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

