/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ChannelsCopier;
import software.amazon.awssdk.services.connect.model.QueuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Filters.getter(Filters::queues)).setter(Filters.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Filters.getter(Filters::channelsAsStrings)).setter(Filters.setter(Builder::channelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CHANNELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> queues;
    private final List<String> channels;

    private Filters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.channels = builder.channels;
    }

    public List<String> queues() {
        return this.queues;
    }

    public List<Channel> channels() {
        return TypeConverter.convert(this.channels, Channel::fromValue);
    }

    public List<String> channelsAsStrings() {
        return this.channels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queues());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return Objects.equals(this.queues(), other.queues()) && Objects.equals(this.channelsAsStrings(), other.channelsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Filters").add("Queues", this.queues()).add("Channels", this.channelsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channelsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.queues(model.queues);
            this.channelsWithStrings(model.channels);
        }

        public final Collection<String> getQueues() {
            return this.queues;
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        public final Collection<String> getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String ... channels) {
            this.channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        public Filters build() {
            return new Filters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filters> {
        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder channelsWithStrings(Collection<String> var1);

        public Builder channelsWithStrings(String ... var1);

        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);
    }
}

