/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRuleEvaluationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::configRuleName)).setter(ConfigRuleEvaluationStatus.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::configRuleArn)).setter(ConfigRuleEvaluationStatus.setter(Builder::configRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleArn").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::configRuleId)).setter(ConfigRuleEvaluationStatus.setter(Builder::configRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleId").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastSuccessfulInvocationTime)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastSuccessfulInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulInvocationTime").build()}).build();
    private static final SdkField<Instant> LAST_FAILED_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastFailedInvocationTime)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastFailedInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailedInvocationTime").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastSuccessfulEvaluationTime)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastSuccessfulEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulEvaluationTime").build()}).build();
    private static final SdkField<Instant> LAST_FAILED_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastFailedEvaluationTime)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastFailedEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailedEvaluationTime").build()}).build();
    private static final SdkField<Instant> FIRST_ACTIVATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::firstActivatedTime)).setter(ConfigRuleEvaluationStatus.setter(Builder::firstActivatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstActivatedTime").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastErrorCode)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::lastErrorMessage)).setter(ConfigRuleEvaluationStatus.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorMessage").build()}).build();
    private static final SdkField<Boolean> FIRST_EVALUATION_STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConfigRuleEvaluationStatus.getter(ConfigRuleEvaluationStatus::firstEvaluationStarted)).setter(ConfigRuleEvaluationStatus.setter(Builder::firstEvaluationStarted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstEvaluationStarted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, CONFIG_RULE_ARN_FIELD, CONFIG_RULE_ID_FIELD, LAST_SUCCESSFUL_INVOCATION_TIME_FIELD, LAST_FAILED_INVOCATION_TIME_FIELD, LAST_SUCCESSFUL_EVALUATION_TIME_FIELD, LAST_FAILED_EVALUATION_TIME_FIELD, FIRST_ACTIVATED_TIME_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, FIRST_EVALUATION_STARTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final Instant lastSuccessfulInvocationTime;
    private final Instant lastFailedInvocationTime;
    private final Instant lastSuccessfulEvaluationTime;
    private final Instant lastFailedEvaluationTime;
    private final Instant firstActivatedTime;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Boolean firstEvaluationStarted;

    private ConfigRuleEvaluationStatus(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.lastSuccessfulInvocationTime = builder.lastSuccessfulInvocationTime;
        this.lastFailedInvocationTime = builder.lastFailedInvocationTime;
        this.lastSuccessfulEvaluationTime = builder.lastSuccessfulEvaluationTime;
        this.lastFailedEvaluationTime = builder.lastFailedEvaluationTime;
        this.firstActivatedTime = builder.firstActivatedTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.firstEvaluationStarted = builder.firstEvaluationStarted;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String configRuleArn() {
        return this.configRuleArn;
    }

    public String configRuleId() {
        return this.configRuleId;
    }

    public Instant lastSuccessfulInvocationTime() {
        return this.lastSuccessfulInvocationTime;
    }

    public Instant lastFailedInvocationTime() {
        return this.lastFailedInvocationTime;
    }

    public Instant lastSuccessfulEvaluationTime() {
        return this.lastSuccessfulEvaluationTime;
    }

    public Instant lastFailedEvaluationTime() {
        return this.lastFailedEvaluationTime;
    }

    public Instant firstActivatedTime() {
        return this.firstActivatedTime;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Boolean firstEvaluationStarted() {
        return this.firstEvaluationStarted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailedInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailedEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstActivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstEvaluationStarted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleEvaluationStatus)) {
            return false;
        }
        ConfigRuleEvaluationStatus other = (ConfigRuleEvaluationStatus)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.configRuleArn(), other.configRuleArn()) && Objects.equals(this.configRuleId(), other.configRuleId()) && Objects.equals(this.lastSuccessfulInvocationTime(), other.lastSuccessfulInvocationTime()) && Objects.equals(this.lastFailedInvocationTime(), other.lastFailedInvocationTime()) && Objects.equals(this.lastSuccessfulEvaluationTime(), other.lastSuccessfulEvaluationTime()) && Objects.equals(this.lastFailedEvaluationTime(), other.lastFailedEvaluationTime()) && Objects.equals(this.firstActivatedTime(), other.firstActivatedTime()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.firstEvaluationStarted(), other.firstEvaluationStarted());
    }

    public String toString() {
        return ToString.builder((String)"ConfigRuleEvaluationStatus").add("ConfigRuleName", (Object)this.configRuleName()).add("ConfigRuleArn", (Object)this.configRuleArn()).add("ConfigRuleId", (Object)this.configRuleId()).add("LastSuccessfulInvocationTime", (Object)this.lastSuccessfulInvocationTime()).add("LastFailedInvocationTime", (Object)this.lastFailedInvocationTime()).add("LastSuccessfulEvaluationTime", (Object)this.lastSuccessfulEvaluationTime()).add("LastFailedEvaluationTime", (Object)this.lastFailedEvaluationTime()).add("FirstActivatedTime", (Object)this.firstActivatedTime()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("FirstEvaluationStarted", (Object)this.firstEvaluationStarted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ConfigRuleArn": {
                return Optional.ofNullable(clazz.cast(this.configRuleArn()));
            }
            case "ConfigRuleId": {
                return Optional.ofNullable(clazz.cast(this.configRuleId()));
            }
            case "LastSuccessfulInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulInvocationTime()));
            }
            case "LastFailedInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.lastFailedInvocationTime()));
            }
            case "LastSuccessfulEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulEvaluationTime()));
            }
            case "LastFailedEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastFailedEvaluationTime()));
            }
            case "FirstActivatedTime": {
                return Optional.ofNullable(clazz.cast(this.firstActivatedTime()));
            }
            case "LastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "LastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "FirstEvaluationStarted": {
                return Optional.ofNullable(clazz.cast(this.firstEvaluationStarted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigRuleEvaluationStatus, T> g) {
        return obj -> g.apply((ConfigRuleEvaluationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private Instant lastSuccessfulInvocationTime;
        private Instant lastFailedInvocationTime;
        private Instant lastSuccessfulEvaluationTime;
        private Instant lastFailedEvaluationTime;
        private Instant firstActivatedTime;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Boolean firstEvaluationStarted;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleEvaluationStatus model) {
            this.configRuleName(model.configRuleName);
            this.configRuleArn(model.configRuleArn);
            this.configRuleId(model.configRuleId);
            this.lastSuccessfulInvocationTime(model.lastSuccessfulInvocationTime);
            this.lastFailedInvocationTime(model.lastFailedInvocationTime);
            this.lastSuccessfulEvaluationTime(model.lastSuccessfulEvaluationTime);
            this.lastFailedEvaluationTime(model.lastFailedEvaluationTime);
            this.firstActivatedTime(model.firstActivatedTime);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.firstEvaluationStarted(model.firstEvaluationStarted);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final Instant getLastSuccessfulInvocationTime() {
            return this.lastSuccessfulInvocationTime;
        }

        @Override
        public final Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
            return this;
        }

        public final void setLastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
        }

        public final Instant getLastFailedInvocationTime() {
            return this.lastFailedInvocationTime;
        }

        @Override
        public final Builder lastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
            return this;
        }

        public final void setLastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
        }

        public final Instant getLastSuccessfulEvaluationTime() {
            return this.lastSuccessfulEvaluationTime;
        }

        @Override
        public final Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
            return this;
        }

        public final void setLastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
        }

        public final Instant getLastFailedEvaluationTime() {
            return this.lastFailedEvaluationTime;
        }

        @Override
        public final Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
            return this;
        }

        public final void setLastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
        }

        public final Instant getFirstActivatedTime() {
            return this.firstActivatedTime;
        }

        @Override
        public final Builder firstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
            return this;
        }

        public final void setFirstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Boolean getFirstEvaluationStarted() {
            return this.firstEvaluationStarted;
        }

        @Override
        public final Builder firstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
            return this;
        }

        public final void setFirstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
        }

        public ConfigRuleEvaluationStatus build() {
            return new ConfigRuleEvaluationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder lastSuccessfulInvocationTime(Instant var1);

        public Builder lastFailedInvocationTime(Instant var1);

        public Builder lastSuccessfulEvaluationTime(Instant var1);

        public Builder lastFailedEvaluationTime(Instant var1);

        public Builder firstActivatedTime(Instant var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder firstEvaluationStarted(Boolean var1);
    }
}

