/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ChronologicalOrder;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceConfigHistoryRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::resourceTypeAsString)).setter(GetResourceConfigHistoryRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::resourceId)).setter(GetResourceConfigHistoryRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<Instant> LATER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::laterTime)).setter(GetResourceConfigHistoryRequest.setter(Builder::laterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("laterTime").build()}).build();
    private static final SdkField<Instant> EARLIER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::earlierTime)).setter(GetResourceConfigHistoryRequest.setter(Builder::earlierTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("earlierTime").build()}).build();
    private static final SdkField<String> CHRONOLOGICAL_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::chronologicalOrderAsString)).setter(GetResourceConfigHistoryRequest.setter(Builder::chronologicalOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chronologicalOrder").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::limit)).setter(GetResourceConfigHistoryRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceConfigHistoryRequest.getter(GetResourceConfigHistoryRequest::nextToken)).setter(GetResourceConfigHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, LATER_TIME_FIELD, EARLIER_TIME_FIELD, CHRONOLOGICAL_ORDER_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String resourceType;
    private final String resourceId;
    private final Instant laterTime;
    private final Instant earlierTime;
    private final String chronologicalOrder;
    private final Integer limit;
    private final String nextToken;

    private GetResourceConfigHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.laterTime = builder.laterTime;
        this.earlierTime = builder.earlierTime;
        this.chronologicalOrder = builder.chronologicalOrder;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Instant laterTime() {
        return this.laterTime;
    }

    public Instant earlierTime() {
        return this.earlierTime;
    }

    public ChronologicalOrder chronologicalOrder() {
        return ChronologicalOrder.fromValue(this.chronologicalOrder);
    }

    public String chronologicalOrderAsString() {
        return this.chronologicalOrder;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.laterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.earlierTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.chronologicalOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryRequest)) {
            return false;
        }
        GetResourceConfigHistoryRequest other = (GetResourceConfigHistoryRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.laterTime(), other.laterTime()) && Objects.equals(this.earlierTime(), other.earlierTime()) && Objects.equals(this.chronologicalOrderAsString(), other.chronologicalOrderAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceConfigHistoryRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("LaterTime", (Object)this.laterTime()).add("EarlierTime", (Object)this.earlierTime()).add("ChronologicalOrder", (Object)this.chronologicalOrderAsString()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "laterTime": {
                return Optional.ofNullable(clazz.cast(this.laterTime()));
            }
            case "earlierTime": {
                return Optional.ofNullable(clazz.cast(this.earlierTime()));
            }
            case "chronologicalOrder": {
                return Optional.ofNullable(clazz.cast(this.chronologicalOrderAsString()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceConfigHistoryRequest, T> g) {
        return obj -> g.apply((GetResourceConfigHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private Instant laterTime;
        private Instant earlierTime;
        private String chronologicalOrder;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.laterTime(model.laterTime);
            this.earlierTime(model.earlierTime);
            this.chronologicalOrder(model.chronologicalOrder);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Instant getLaterTime() {
            return this.laterTime;
        }

        @Override
        public final Builder laterTime(Instant laterTime) {
            this.laterTime = laterTime;
            return this;
        }

        public final void setLaterTime(Instant laterTime) {
            this.laterTime = laterTime;
        }

        public final Instant getEarlierTime() {
            return this.earlierTime;
        }

        @Override
        public final Builder earlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
            return this;
        }

        public final void setEarlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
        }

        public final String getChronologicalOrderAsString() {
            return this.chronologicalOrder;
        }

        @Override
        public final Builder chronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
            return this;
        }

        @Override
        public final Builder chronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
            return this;
        }

        public final void setChronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceConfigHistoryRequest build() {
            return new GetResourceConfigHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder laterTime(Instant var1);

        public Builder earlierTime(Instant var1);

        public Builder chronologicalOrder(String var1);

        public Builder chronologicalOrder(ChronologicalOrder var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

