/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateResourceIdentifier> {
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregateResourceIdentifier.getter(AggregateResourceIdentifier::sourceAccountId)).setter(AggregateResourceIdentifier.setter(Builder::sourceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregateResourceIdentifier.getter(AggregateResourceIdentifier::sourceRegion)).setter(AggregateResourceIdentifier.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregateResourceIdentifier.getter(AggregateResourceIdentifier::resourceId)).setter(AggregateResourceIdentifier.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregateResourceIdentifier.getter(AggregateResourceIdentifier::resourceTypeAsString)).setter(AggregateResourceIdentifier.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregateResourceIdentifier.getter(AggregateResourceIdentifier::resourceName)).setter(AggregateResourceIdentifier.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ACCOUNT_ID_FIELD, SOURCE_REGION_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceAccountId;
    private final String sourceRegion;
    private final String resourceId;
    private final String resourceType;
    private final String resourceName;

    private AggregateResourceIdentifier(BuilderImpl builder) {
        this.sourceAccountId = builder.sourceAccountId;
        this.sourceRegion = builder.sourceRegion;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
    }

    public String sourceAccountId() {
        return this.sourceAccountId;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateResourceIdentifier)) {
            return false;
        }
        AggregateResourceIdentifier other = (AggregateResourceIdentifier)obj;
        return Objects.equals(this.sourceAccountId(), other.sourceAccountId()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceName(), other.resourceName());
    }

    public String toString() {
        return ToString.builder((String)"AggregateResourceIdentifier").add("SourceAccountId", (Object)this.sourceAccountId()).add("SourceRegion", (Object)this.sourceRegion()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceName", (Object)this.resourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAccountId": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountId()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateResourceIdentifier, T> g) {
        return obj -> g.apply((AggregateResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceAccountId;
        private String sourceRegion;
        private String resourceId;
        private String resourceType;
        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateResourceIdentifier model) {
            this.sourceAccountId(model.sourceAccountId);
            this.sourceRegion(model.sourceRegion);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceName(model.resourceName);
        }

        public final String getSourceAccountId() {
            return this.sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public AggregateResourceIdentifier build() {
            return new AggregateResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateResourceIdentifier> {
        public Builder sourceAccountId(String var1);

        public Builder sourceRegion(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceName(String var1);
    }
}

