/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.RemediationExecutionStatus;
import software.amazon.awssdk.services.config.model.RemediationExecutionStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRemediationExecutionStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeRemediationExecutionStatusResponse> {
    private static final SdkField<List<RemediationExecutionStatus>> REMEDIATION_EXECUTION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRemediationExecutionStatusResponse.getter(DescribeRemediationExecutionStatusResponse::remediationExecutionStatuses)).setter(DescribeRemediationExecutionStatusResponse.setter(Builder::remediationExecutionStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationExecutionStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRemediationExecutionStatusResponse.getter(DescribeRemediationExecutionStatusResponse::nextToken)).setter(DescribeRemediationExecutionStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_EXECUTION_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RemediationExecutionStatus> remediationExecutionStatuses;
    private final String nextToken;

    private DescribeRemediationExecutionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.remediationExecutionStatuses = builder.remediationExecutionStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<RemediationExecutionStatus> remediationExecutionStatuses() {
        return this.remediationExecutionStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationExecutionStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExecutionStatusResponse)) {
            return false;
        }
        DescribeRemediationExecutionStatusResponse other = (DescribeRemediationExecutionStatusResponse)((Object)obj);
        return Objects.equals(this.remediationExecutionStatuses(), other.remediationExecutionStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRemediationExecutionStatusResponse").add("RemediationExecutionStatuses", this.remediationExecutionStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemediationExecutionStatuses": {
                return Optional.ofNullable(clazz.cast(this.remediationExecutionStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExecutionStatusResponse, T> g) {
        return obj -> g.apply((DescribeRemediationExecutionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<RemediationExecutionStatus> remediationExecutionStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExecutionStatusResponse model) {
            super(model);
            this.remediationExecutionStatuses(model.remediationExecutionStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<RemediationExecutionStatus.Builder> getRemediationExecutionStatuses() {
            return this.remediationExecutionStatuses != null ? (Collection)this.remediationExecutionStatuses.stream().map(RemediationExecutionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remediationExecutionStatuses(Collection<RemediationExecutionStatus> remediationExecutionStatuses) {
            this.remediationExecutionStatuses = RemediationExecutionStatusesCopier.copy(remediationExecutionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExecutionStatuses(RemediationExecutionStatus ... remediationExecutionStatuses) {
            this.remediationExecutionStatuses(Arrays.asList(remediationExecutionStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExecutionStatuses(Consumer<RemediationExecutionStatus.Builder> ... remediationExecutionStatuses) {
            this.remediationExecutionStatuses(Stream.of(remediationExecutionStatuses).map(c -> (RemediationExecutionStatus)((RemediationExecutionStatus.Builder)RemediationExecutionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemediationExecutionStatuses(Collection<RemediationExecutionStatus.BuilderImpl> remediationExecutionStatuses) {
            this.remediationExecutionStatuses = RemediationExecutionStatusesCopier.copyFromBuilder(remediationExecutionStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRemediationExecutionStatusResponse build() {
            return new DescribeRemediationExecutionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRemediationExecutionStatusResponse> {
        public Builder remediationExecutionStatuses(Collection<RemediationExecutionStatus> var1);

        public Builder remediationExecutionStatuses(RemediationExecutionStatus ... var1);

        public Builder remediationExecutionStatuses(Consumer<RemediationExecutionStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

