/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetResourceConfigRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, BatchGetResourceConfigRequest> {
    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetResourceConfigRequest.getter(BatchGetResourceConfigRequest::resourceKeys)).setter(BatchGetResourceConfigRequest.setter(Builder::resourceKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_KEYS_FIELD));
    private final List<ResourceKey> resourceKeys;

    private BatchGetResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceKeys = builder.resourceKeys;
    }

    public List<ResourceKey> resourceKeys() {
        return this.resourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigRequest)) {
            return false;
        }
        BatchGetResourceConfigRequest other = (BatchGetResourceConfigRequest)((Object)obj);
        return Objects.equals(this.resourceKeys(), other.resourceKeys());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetResourceConfigRequest").add("ResourceKeys", this.resourceKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceKeys": {
                return Optional.ofNullable(clazz.cast(this.resourceKeys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetResourceConfigRequest, T> g) {
        return obj -> g.apply((BatchGetResourceConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigRequest model) {
            super(model);
            this.resourceKeys(model.resourceKeys);
        }

        public final Collection<ResourceKey.Builder> getResourceKeys() {
            return this.resourceKeys != null ? (Collection)this.resourceKeys.stream().map(ResourceKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey ... resourceKeys) {
            this.resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder> ... resourceKeys) {
            this.resourceKeys(Stream.of(resourceKeys).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetResourceConfigRequest build() {
            return new BatchGetResourceConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetResourceConfigRequest> {
        public Builder resourceKeys(Collection<ResourceKey> var1);

        public Builder resourceKeys(ResourceKey ... var1);

        public Builder resourceKeys(Consumer<ResourceKey.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

