/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.config.model.RemediationParameterValue;
import software.amazon.awssdk.services.config.model.RemediationParametersCopier;
import software.amazon.awssdk.services.config.model.RemediationTargetType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemediationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemediationConfiguration> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationConfiguration.getter(RemediationConfiguration::configRuleName)).setter(RemediationConfiguration.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationConfiguration.getter(RemediationConfiguration::targetTypeAsString)).setter(RemediationConfiguration.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationConfiguration.getter(RemediationConfiguration::targetId)).setter(RemediationConfiguration.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationConfiguration.getter(RemediationConfiguration::targetVersion)).setter(RemediationConfiguration.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Map<String, RemediationParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(RemediationConfiguration.getter(RemediationConfiguration::parameters)).setter(RemediationConfiguration.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationConfiguration.getter(RemediationConfiguration::resourceType)).setter(RemediationConfiguration.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, TARGET_TYPE_FIELD, TARGET_ID_FIELD, TARGET_VERSION_FIELD, PARAMETERS_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String targetType;
    private final String targetId;
    private final String targetVersion;
    private final Map<String, RemediationParameterValue> parameters;
    private final String resourceType;

    private RemediationConfiguration(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.targetVersion = builder.targetVersion;
        this.parameters = builder.parameters;
        this.resourceType = builder.resourceType;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public RemediationTargetType targetType() {
        return RemediationTargetType.fromValue(this.targetType);
    }

    public String targetTypeAsString() {
        return this.targetType;
    }

    public String targetId() {
        return this.targetId;
    }

    public String targetVersion() {
        return this.targetVersion;
    }

    public Map<String, RemediationParameterValue> parameters() {
        return this.parameters;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public String toString() {
        return ToString.builder((String)"RemediationConfiguration").add("ConfigRuleName", (Object)this.configRuleName()).add("TargetType", (Object)this.targetTypeAsString()).add("TargetId", (Object)this.targetId()).add("TargetVersion", (Object)this.targetVersion()).add("Parameters", this.parameters()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationConfiguration, T> g) {
        return obj -> g.apply((RemediationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String targetType;
        private String targetId;
        private String targetVersion;
        private Map<String, RemediationParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationConfiguration model) {
            this.configRuleName(model.configRuleName);
            this.targetType(model.targetType);
            this.targetId(model.targetId);
            this.targetVersion(model.targetVersion);
            this.parameters(model.parameters);
            this.resourceType(model.resourceType);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getTargetTypeAsString() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RemediationTargetType targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Map<String, RemediationParameterValue.Builder> getParameters() {
            return this.parameters != null ? CollectionUtils.mapValues(this.parameters, RemediationParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, RemediationParameterValue> parameters) {
            this.parameters = RemediationParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, RemediationParameterValue.BuilderImpl> parameters) {
            this.parameters = RemediationParametersCopier.copyFromBuilder(parameters);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public RemediationConfiguration build() {
            return new RemediationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemediationConfiguration> {
        public Builder configRuleName(String var1);

        public Builder targetType(String var1);

        public Builder targetType(RemediationTargetType var1);

        public Builder targetId(String var1);

        public Builder targetVersion(String var1);

        public Builder parameters(Map<String, RemediationParameterValue> var1);

        public Builder resourceType(String var1);
    }
}

