/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AggregatedSourceType {
    ACCOUNT("ACCOUNT"),
    ORGANIZATION("ORGANIZATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AggregatedSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregatedSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AggregatedSourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregatedSourceType> knownValues() {
        return Stream.of(AggregatedSourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

