/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceDetailsByResourceRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetComplianceDetailsByResourceRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetComplianceDetailsByResourceRequest.getter(GetComplianceDetailsByResourceRequest::resourceType)).setter(GetComplianceDetailsByResourceRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(GetComplianceDetailsByResourceRequest.getter(GetComplianceDetailsByResourceRequest::resourceId)).setter(GetComplianceDetailsByResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<List<String>> COMPLIANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceTypes").getter(GetComplianceDetailsByResourceRequest.getter(GetComplianceDetailsByResourceRequest::complianceTypesAsStrings)).setter(GetComplianceDetailsByResourceRequest.setter(Builder::complianceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetComplianceDetailsByResourceRequest.getter(GetComplianceDetailsByResourceRequest::nextToken)).setter(GetComplianceDetailsByResourceRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceEvaluationId").getter(GetComplianceDetailsByResourceRequest.getter(GetComplianceDetailsByResourceRequest::resourceEvaluationId)).setter(GetComplianceDetailsByResourceRequest.setter(Builder::resourceEvaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, COMPLIANCE_TYPES_FIELD, NEXT_TOKEN_FIELD, RESOURCE_EVALUATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetComplianceDetailsByResourceRequest.memberNameToFieldInitializer();
    private final String resourceType;
    private final String resourceId;
    private final List<String> complianceTypes;
    private final String nextToken;
    private final String resourceEvaluationId;

    private GetComplianceDetailsByResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.complianceTypes = builder.complianceTypes;
        this.nextToken = builder.nextToken;
        this.resourceEvaluationId = builder.resourceEvaluationId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final List<ComplianceType> complianceTypes() {
        return ComplianceTypesCopier.copyStringToEnum(this.complianceTypes);
    }

    public final boolean hasComplianceTypes() {
        return this.complianceTypes != null && !(this.complianceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> complianceTypesAsStrings() {
        return this.complianceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resourceEvaluationId() {
        return this.resourceEvaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceEvaluationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByResourceRequest)) {
            return false;
        }
        GetComplianceDetailsByResourceRequest other = (GetComplianceDetailsByResourceRequest)((Object)obj);
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasComplianceTypes() == other.hasComplianceTypes() && Objects.equals(this.complianceTypesAsStrings(), other.complianceTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceEvaluationId(), other.resourceEvaluationId());
    }

    public final String toString() {
        return ToString.builder((String)"GetComplianceDetailsByResourceRequest").add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("ComplianceTypes", this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("ResourceEvaluationId", (Object)this.resourceEvaluationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ComplianceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceTypesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResourceEvaluationId": {
                return Optional.ofNullable(clazz.cast(this.resourceEvaluationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ComplianceTypes", COMPLIANCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByResourceRequest, T> g) {
        return obj -> g.apply((GetComplianceDetailsByResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private List<String> complianceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String resourceEvaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByResourceRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.complianceTypesWithStrings(model.complianceTypes);
            this.nextToken(model.nextToken);
            this.resourceEvaluationId(model.resourceEvaluationId);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getComplianceTypes() {
            if (this.complianceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceTypes;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @Override
        public final Builder complianceTypesWithStrings(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypesWithStrings(String ... complianceTypes) {
            this.complianceTypesWithStrings(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        public final Builder complianceTypes(Collection<ComplianceType> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copyEnumToString(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceEvaluationId() {
            return this.resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceDetailsByResourceRequest build() {
            return new GetComplianceDetailsByResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceDetailsByResourceRequest> {
        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder complianceTypesWithStrings(Collection<String> var1);

        public Builder complianceTypesWithStrings(String ... var1);

        public Builder complianceTypes(Collection<ComplianceType> var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder nextToken(String var1);

        public Builder resourceEvaluationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

