/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.EvaluationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationResultQualifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationResultQualifier> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(EvaluationResultQualifier.getter(EvaluationResultQualifier::configRuleName)).setter(EvaluationResultQualifier.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(EvaluationResultQualifier.getter(EvaluationResultQualifier::resourceType)).setter(EvaluationResultQualifier.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(EvaluationResultQualifier.getter(EvaluationResultQualifier::resourceId)).setter(EvaluationResultQualifier.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMode").getter(EvaluationResultQualifier.getter(EvaluationResultQualifier::evaluationModeAsString)).setter(EvaluationResultQualifier.setter(Builder::evaluationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, EVALUATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationResultQualifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String resourceType;
    private final String resourceId;
    private final String evaluationMode;

    private EvaluationResultQualifier(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.evaluationMode = builder.evaluationMode;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(this.evaluationMode);
    }

    public final String evaluationModeAsString() {
        return this.evaluationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultQualifier)) {
            return false;
        }
        EvaluationResultQualifier other = (EvaluationResultQualifier)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.evaluationModeAsString(), other.evaluationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationResultQualifier").add("ConfigRuleName", (Object)this.configRuleName()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("EvaluationMode", (Object)this.evaluationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "EvaluationMode": {
                return Optional.ofNullable(clazz.cast(this.evaluationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConfigRuleName", CONFIG_RULE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("EvaluationMode", EVALUATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResultQualifier, T> g) {
        return obj -> g.apply((EvaluationResultQualifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String resourceType;
        private String resourceId;
        private String evaluationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultQualifier model) {
            this.configRuleName(model.configRuleName);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.evaluationMode(model.evaluationMode);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getEvaluationMode() {
            return this.evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public EvaluationResultQualifier build() {
            return new EvaluationResultQualifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationResultQualifier> {
        public Builder configRuleName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder evaluationMode(String var1);

        public Builder evaluationMode(EvaluationMode var1);
    }
}

