/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ResourceCount;
import software.amazon.awssdk.services.config.model.ResourceCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDiscoveredResourceCountsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
    private static final SdkField<Long> TOTAL_DISCOVERED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalDiscoveredResources").getter(GetDiscoveredResourceCountsResponse.getter(GetDiscoveredResourceCountsResponse::totalDiscoveredResources)).setter(GetDiscoveredResourceCountsResponse.setter(Builder::totalDiscoveredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDiscoveredResources").build()}).build();
    private static final SdkField<List<ResourceCount>> RESOURCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceCounts").getter(GetDiscoveredResourceCountsResponse.getter(GetDiscoveredResourceCountsResponse::resourceCounts)).setter(GetDiscoveredResourceCountsResponse.setter(Builder::resourceCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDiscoveredResourceCountsResponse.getter(GetDiscoveredResourceCountsResponse::nextToken)).setter(GetDiscoveredResourceCountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_DISCOVERED_RESOURCES_FIELD, RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDiscoveredResourceCountsResponse.memberNameToFieldInitializer();
    private final Long totalDiscoveredResources;
    private final List<ResourceCount> resourceCounts;
    private final String nextToken;

    private GetDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.resourceCounts = builder.resourceCounts;
        this.nextToken = builder.nextToken;
    }

    public final Long totalDiscoveredResources() {
        return this.totalDiscoveredResources;
    }

    public final boolean hasResourceCounts() {
        return this.resourceCounts != null && !(this.resourceCounts instanceof SdkAutoConstructList);
    }

    public final List<ResourceCount> resourceCounts() {
        return this.resourceCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceCounts() ? this.resourceCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetDiscoveredResourceCountsResponse other = (GetDiscoveredResourceCountsResponse)((Object)obj);
        return Objects.equals(this.totalDiscoveredResources(), other.totalDiscoveredResources()) && this.hasResourceCounts() == other.hasResourceCounts() && Objects.equals(this.resourceCounts(), other.resourceCounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDiscoveredResourceCountsResponse").add("TotalDiscoveredResources", (Object)this.totalDiscoveredResources()).add("ResourceCounts", this.hasResourceCounts() ? this.resourceCounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalDiscoveredResources": {
                return Optional.ofNullable(clazz.cast(this.totalDiscoveredResources()));
            }
            case "resourceCounts": {
                return Optional.ofNullable(clazz.cast(this.resourceCounts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totalDiscoveredResources", TOTAL_DISCOVERED_RESOURCES_FIELD);
        map.put("resourceCounts", RESOURCE_COUNTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoveredResourceCountsResponse, T> g) {
        return obj -> g.apply((GetDiscoveredResourceCountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private Long totalDiscoveredResources;
        private List<ResourceCount> resourceCounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsResponse model) {
            super(model);
            this.totalDiscoveredResources(model.totalDiscoveredResources);
            this.resourceCounts(model.resourceCounts);
            this.nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return this.totalDiscoveredResources;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final List<ResourceCount.Builder> getResourceCounts() {
            List<ResourceCount.Builder> result = ResourceCountsCopier.copyToBuilder(this.resourceCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceCounts(Collection<ResourceCount.BuilderImpl> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copyFromBuilder(resourceCounts);
        }

        @Override
        public final Builder resourceCounts(Collection<ResourceCount> resourceCounts) {
            this.resourceCounts = ResourceCountsCopier.copy(resourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(ResourceCount ... resourceCounts) {
            this.resourceCounts(Arrays.asList(resourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceCounts(Consumer<ResourceCount.Builder> ... resourceCounts) {
            this.resourceCounts(Stream.of(resourceCounts).map(c -> (ResourceCount)((ResourceCount.Builder)ResourceCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDiscoveredResourceCountsResponse build() {
            return new GetDiscoveredResourceCountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDiscoveredResourceCountsResponse> {
        public Builder totalDiscoveredResources(Long var1);

        public Builder resourceCounts(Collection<ResourceCount> var1);

        public Builder resourceCounts(ResourceCount ... var1);

        public Builder resourceCounts(Consumer<ResourceCount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

