/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;

public class ListConfigurationRecordersIterable
implements SdkIterable<ListConfigurationRecordersResponse> {
    private final ConfigClient client;
    private final ListConfigurationRecordersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationRecordersIterable(ConfigClient client, ListConfigurationRecordersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationRecordersResponseFetcher();
    }

    public Iterator<ListConfigurationRecordersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationRecorderSummary> configurationRecorderSummaries() {
        Function<ListConfigurationRecordersResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationRecorderSummaries() != null) {
                return response.configurationRecorderSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationRecordersResponseFetcher
    implements SyncPageFetcher<ListConfigurationRecordersResponse> {
        private ListConfigurationRecordersResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationRecordersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationRecordersResponse nextPage(ListConfigurationRecordersResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationRecordersIterable.this.client.listConfigurationRecorders(ListConfigurationRecordersIterable.this.firstRequest);
            }
            return ListConfigurationRecordersIterable.this.client.listConfigurationRecorders((ListConfigurationRecordersRequest)((Object)ListConfigurationRecordersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

