/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;

public class DescribeConformancePackCompliancePublisher
implements SdkPublisher<DescribeConformancePackComplianceResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConformancePackComplianceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConformancePackCompliancePublisher(ConfigAsyncClient client, DescribeConformancePackComplianceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConformancePackCompliancePublisher(ConfigAsyncClient client, DescribeConformancePackComplianceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConformancePackComplianceResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConformancePackComplianceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeConformancePackComplianceResponseFetcher
    implements AsyncPageFetcher<DescribeConformancePackComplianceResponse> {
        private DescribeConformancePackComplianceResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConformancePackComplianceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConformancePackComplianceResponse> nextPage(DescribeConformancePackComplianceResponse previousPage) {
            if (previousPage == null) {
                return DescribeConformancePackCompliancePublisher.this.client.describeConformancePackCompliance(DescribeConformancePackCompliancePublisher.this.firstRequest);
            }
            return DescribeConformancePackCompliancePublisher.this.client.describeConformancePackCompliance((DescribeConformancePackComplianceRequest)((Object)DescribeConformancePackCompliancePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

