/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordingScope {
    INTERNAL("INTERNAL"),
    PAID("PAID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordingScope> VALUE_MAP;
    private final String value;

    private RecordingScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordingScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordingScope> knownValues() {
        EnumSet<RecordingScope> knownValues = EnumSet.allOf(RecordingScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordingScope.class, RecordingScope::toString);
    }
}

