/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateComplianceCount;
import software.amazon.awssdk.services.config.model.AggregateComplianceCountListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregateConfigRuleComplianceSummaryResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetAggregateConfigRuleComplianceSummaryResponse> {
    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateConfigRuleComplianceSummaryResponse.getter(GetAggregateConfigRuleComplianceSummaryResponse::groupByKey)).setter(GetAggregateConfigRuleComplianceSummaryResponse.setter(Builder::groupByKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()}).build();
    private static final SdkField<List<AggregateComplianceCount>> AGGREGATE_COMPLIANCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAggregateConfigRuleComplianceSummaryResponse.getter(GetAggregateConfigRuleComplianceSummaryResponse::aggregateComplianceCounts)).setter(GetAggregateConfigRuleComplianceSummaryResponse.setter(Builder::aggregateComplianceCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateComplianceCounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateComplianceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateConfigRuleComplianceSummaryResponse.getter(GetAggregateConfigRuleComplianceSummaryResponse::nextToken)).setter(GetAggregateConfigRuleComplianceSummaryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_KEY_FIELD, AGGREGATE_COMPLIANCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private final String groupByKey;
    private final List<AggregateComplianceCount> aggregateComplianceCounts;
    private final String nextToken;

    private GetAggregateConfigRuleComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.groupByKey = builder.groupByKey;
        this.aggregateComplianceCounts = builder.aggregateComplianceCounts;
        this.nextToken = builder.nextToken;
    }

    public String groupByKey() {
        return this.groupByKey;
    }

    public List<AggregateComplianceCount> aggregateComplianceCounts() {
        return this.aggregateComplianceCounts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateComplianceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateConfigRuleComplianceSummaryResponse)) {
            return false;
        }
        GetAggregateConfigRuleComplianceSummaryResponse other = (GetAggregateConfigRuleComplianceSummaryResponse)((Object)obj);
        return Objects.equals(this.groupByKey(), other.groupByKey()) && Objects.equals(this.aggregateComplianceCounts(), other.aggregateComplianceCounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAggregateConfigRuleComplianceSummaryResponse").add("GroupByKey", (Object)this.groupByKey()).add("AggregateComplianceCounts", this.aggregateComplianceCounts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupByKey": {
                return Optional.ofNullable(clazz.cast(this.groupByKey()));
            }
            case "AggregateComplianceCounts": {
                return Optional.ofNullable(clazz.cast(this.aggregateComplianceCounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateConfigRuleComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetAggregateConfigRuleComplianceSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String groupByKey;
        private List<AggregateComplianceCount> aggregateComplianceCounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateConfigRuleComplianceSummaryResponse model) {
            super(model);
            this.groupByKey(model.groupByKey);
            this.aggregateComplianceCounts(model.aggregateComplianceCounts);
            this.nextToken(model.nextToken);
        }

        public final String getGroupByKey() {
            return this.groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        public final Collection<AggregateComplianceCount.Builder> getAggregateComplianceCounts() {
            return this.aggregateComplianceCounts != null ? (Collection)this.aggregateComplianceCounts.stream().map(AggregateComplianceCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregateComplianceCounts(Collection<AggregateComplianceCount> aggregateComplianceCounts) {
            this.aggregateComplianceCounts = AggregateComplianceCountListCopier.copy(aggregateComplianceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceCounts(AggregateComplianceCount ... aggregateComplianceCounts) {
            this.aggregateComplianceCounts(Arrays.asList(aggregateComplianceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceCounts(Consumer<AggregateComplianceCount.Builder> ... aggregateComplianceCounts) {
            this.aggregateComplianceCounts(Stream.of(aggregateComplianceCounts).map(c -> (AggregateComplianceCount)((AggregateComplianceCount.Builder)AggregateComplianceCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateComplianceCounts(Collection<AggregateComplianceCount.BuilderImpl> aggregateComplianceCounts) {
            this.aggregateComplianceCounts = AggregateComplianceCountListCopier.copyFromBuilder(aggregateComplianceCounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAggregateConfigRuleComplianceSummaryResponse build() {
            return new GetAggregateConfigRuleComplianceSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregateConfigRuleComplianceSummaryResponse> {
        public Builder groupByKey(String var1);

        public Builder aggregateComplianceCounts(Collection<AggregateComplianceCount> var1);

        public Builder aggregateComplianceCounts(AggregateComplianceCount ... var1);

        public Builder aggregateComplianceCounts(Consumer<AggregateComplianceCount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

