/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.EvaluationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceDetailsByConfigRuleResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetComplianceDetailsByConfigRuleResponse> {
    private static final SdkField<List<EvaluationResult>> EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationResults").getter(GetComplianceDetailsByConfigRuleResponse.getter(GetComplianceDetailsByConfigRuleResponse::evaluationResults)).setter(GetComplianceDetailsByConfigRuleResponse.setter(Builder::evaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetComplianceDetailsByConfigRuleResponse.getter(GetComplianceDetailsByConfigRuleResponse::nextToken)).setter(GetComplianceDetailsByConfigRuleResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetComplianceDetailsByConfigRuleResponse.memberNameToFieldInitializer();
    private final List<EvaluationResult> evaluationResults;
    private final String nextToken;

    private GetComplianceDetailsByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvaluationResults() {
        return this.evaluationResults != null && !(this.evaluationResults instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationResults() ? this.evaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleResponse)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleResponse other = (GetComplianceDetailsByConfigRuleResponse)((Object)obj);
        return this.hasEvaluationResults() == other.hasEvaluationResults() && Objects.equals(this.evaluationResults(), other.evaluationResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetComplianceDetailsByConfigRuleResponse").add("EvaluationResults", this.hasEvaluationResults() ? this.evaluationResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.evaluationResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationResults", EVALUATION_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByConfigRuleResponse, T> g) {
        return obj -> g.apply((GetComplianceDetailsByConfigRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleResponse model) {
            super(model);
            this.evaluationResults(model.evaluationResults);
            this.nextToken(model.nextToken);
        }

        public final List<EvaluationResult.Builder> getEvaluationResults() {
            List<EvaluationResult.Builder> result = EvaluationResultsCopier.copyToBuilder(this.evaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder> ... evaluationResults) {
            this.evaluationResults(Stream.of(evaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetComplianceDetailsByConfigRuleResponse build() {
            return new GetComplianceDetailsByConfigRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleResponse> {
        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder evaluationResults(Consumer<EvaluationResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

