/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationItemStatus {
    OK("OK"),
    RESOURCE_DISCOVERED("ResourceDiscovered"),
    RESOURCE_NOT_RECORDED("ResourceNotRecorded"),
    RESOURCE_DELETED("ResourceDeleted"),
    RESOURCE_DELETED_NOT_RECORDED("ResourceDeletedNotRecorded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationItemStatus> VALUE_MAP;
    private final String value;

    private ConfigurationItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationItemStatus> knownValues() {
        EnumSet<ConfigurationItemStatus> knownValues = EnumSet.allOf(ConfigurationItemStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationItemStatus.class, ConfigurationItemStatus::toString);
    }
}

