/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;

public class DescribeAggregateComplianceByConfigRulesPublisher
implements SdkPublisher<DescribeAggregateComplianceByConfigRulesResponse> {
    private final ConfigAsyncClient client;
    private final DescribeAggregateComplianceByConfigRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAggregateComplianceByConfigRulesPublisher(ConfigAsyncClient client, DescribeAggregateComplianceByConfigRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAggregateComplianceByConfigRulesPublisher(ConfigAsyncClient client, DescribeAggregateComplianceByConfigRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAggregateComplianceByConfigRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAggregateComplianceByConfigRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeAggregateComplianceByConfigRulesResponseFetcher
    implements AsyncPageFetcher<DescribeAggregateComplianceByConfigRulesResponse> {
        private DescribeAggregateComplianceByConfigRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAggregateComplianceByConfigRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> nextPage(DescribeAggregateComplianceByConfigRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAggregateComplianceByConfigRulesPublisher.this.client.describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesPublisher.this.firstRequest);
            }
            return DescribeAggregateComplianceByConfigRulesPublisher.this.client.describeAggregateComplianceByConfigRules((DescribeAggregateComplianceByConfigRulesRequest)((Object)DescribeAggregateComplianceByConfigRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

