/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus;

public class GetOrganizationConformancePackDetailedStatusPublisher
implements SdkPublisher<GetOrganizationConformancePackDetailedStatusResponse> {
    private final ConfigAsyncClient client;
    private final GetOrganizationConformancePackDetailedStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOrganizationConformancePackDetailedStatusPublisher(ConfigAsyncClient client, GetOrganizationConformancePackDetailedStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOrganizationConformancePackDetailedStatusPublisher(ConfigAsyncClient client, GetOrganizationConformancePackDetailedStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOrganizationConformancePackDetailedStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOrganizationConformancePackDetailedStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses() {
        Function<GetOrganizationConformancePackDetailedStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConformancePackDetailedStatuses() != null) {
                return response.organizationConformancePackDetailedStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOrganizationConformancePackDetailedStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetOrganizationConformancePackDetailedStatusResponseFetcher
    implements AsyncPageFetcher<GetOrganizationConformancePackDetailedStatusResponse> {
        private GetOrganizationConformancePackDetailedStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetOrganizationConformancePackDetailedStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> nextPage(GetOrganizationConformancePackDetailedStatusResponse previousPage) {
            if (previousPage == null) {
                return GetOrganizationConformancePackDetailedStatusPublisher.this.client.getOrganizationConformancePackDetailedStatus(GetOrganizationConformancePackDetailedStatusPublisher.this.firstRequest);
            }
            return GetOrganizationConformancePackDetailedStatusPublisher.this.client.getOrganizationConformancePackDetailedStatus((GetOrganizationConformancePackDetailedStatusRequest)((Object)GetOrganizationConformancePackDetailedStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

