/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;

public class SelectResourceConfigIterable
implements SdkIterable<SelectResourceConfigResponse> {
    private final ConfigClient client;
    private final SelectResourceConfigRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SelectResourceConfigIterable(ConfigClient client, SelectResourceConfigRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SelectResourceConfigResponseFetcher();
    }

    public Iterator<SelectResourceConfigResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> results() {
        Function<SelectResourceConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SelectResourceConfigResponseFetcher
    implements SyncPageFetcher<SelectResourceConfigResponse> {
        private SelectResourceConfigResponseFetcher() {
        }

        public boolean hasNextPage(SelectResourceConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SelectResourceConfigResponse nextPage(SelectResourceConfigResponse previousPage) {
            if (previousPage == null) {
                return SelectResourceConfigIterable.this.client.selectResourceConfig(SelectResourceConfigIterable.this.firstRequest);
            }
            return SelectResourceConfigIterable.this.client.selectResourceConfig((SelectResourceConfigRequest)((Object)SelectResourceConfigIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

