/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.RecordingFrequency;
import software.amazon.awssdk.services.config.model.RecordingModeOverride;
import software.amazon.awssdk.services.config.model.RecordingModeOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingMode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingMode> {
    private static final SdkField<String> RECORDING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingFrequency").getter(RecordingMode.getter(RecordingMode::recordingFrequencyAsString)).setter(RecordingMode.setter(Builder::recordingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingFrequency").build()}).build();
    private static final SdkField<List<RecordingModeOverride>> RECORDING_MODE_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recordingModeOverrides").getter(RecordingMode.getter(RecordingMode::recordingModeOverrides)).setter(RecordingMode.setter(Builder::recordingModeOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingModeOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordingModeOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_FREQUENCY_FIELD, RECORDING_MODE_OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recordingFrequency;
    private final List<RecordingModeOverride> recordingModeOverrides;

    private RecordingMode(BuilderImpl builder) {
        this.recordingFrequency = builder.recordingFrequency;
        this.recordingModeOverrides = builder.recordingModeOverrides;
    }

    public final RecordingFrequency recordingFrequency() {
        return RecordingFrequency.fromValue(this.recordingFrequency);
    }

    public final String recordingFrequencyAsString() {
        return this.recordingFrequency;
    }

    public final boolean hasRecordingModeOverrides() {
        return this.recordingModeOverrides != null && !(this.recordingModeOverrides instanceof SdkAutoConstructList);
    }

    public final List<RecordingModeOverride> recordingModeOverrides() {
        return this.recordingModeOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordingModeOverrides() ? this.recordingModeOverrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingMode)) {
            return false;
        }
        RecordingMode other = (RecordingMode)obj;
        return Objects.equals(this.recordingFrequencyAsString(), other.recordingFrequencyAsString()) && this.hasRecordingModeOverrides() == other.hasRecordingModeOverrides() && Objects.equals(this.recordingModeOverrides(), other.recordingModeOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingMode").add("RecordingFrequency", (Object)this.recordingFrequencyAsString()).add("RecordingModeOverrides", this.hasRecordingModeOverrides() ? this.recordingModeOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recordingFrequency": {
                return Optional.ofNullable(clazz.cast(this.recordingFrequencyAsString()));
            }
            case "recordingModeOverrides": {
                return Optional.ofNullable(clazz.cast(this.recordingModeOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordingMode, T> g) {
        return obj -> g.apply((RecordingMode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordingFrequency;
        private List<RecordingModeOverride> recordingModeOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingMode model) {
            this.recordingFrequency(model.recordingFrequency);
            this.recordingModeOverrides(model.recordingModeOverrides);
        }

        public final String getRecordingFrequency() {
            return this.recordingFrequency;
        }

        public final void setRecordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
        }

        @Override
        public final Builder recordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
            return this;
        }

        @Override
        public final Builder recordingFrequency(RecordingFrequency recordingFrequency) {
            this.recordingFrequency(recordingFrequency == null ? null : recordingFrequency.toString());
            return this;
        }

        public final List<RecordingModeOverride.Builder> getRecordingModeOverrides() {
            List<RecordingModeOverride.Builder> result = RecordingModeOverridesCopier.copyToBuilder(this.recordingModeOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordingModeOverrides(Collection<RecordingModeOverride.BuilderImpl> recordingModeOverrides) {
            this.recordingModeOverrides = RecordingModeOverridesCopier.copyFromBuilder(recordingModeOverrides);
        }

        @Override
        public final Builder recordingModeOverrides(Collection<RecordingModeOverride> recordingModeOverrides) {
            this.recordingModeOverrides = RecordingModeOverridesCopier.copy(recordingModeOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordingModeOverrides(RecordingModeOverride ... recordingModeOverrides) {
            this.recordingModeOverrides(Arrays.asList(recordingModeOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordingModeOverrides(Consumer<RecordingModeOverride.Builder> ... recordingModeOverrides) {
            this.recordingModeOverrides(Stream.of(recordingModeOverrides).map(c -> (RecordingModeOverride)((RecordingModeOverride.Builder)RecordingModeOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecordingMode build() {
            return new RecordingMode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingMode> {
        public Builder recordingFrequency(String var1);

        public Builder recordingFrequency(RecordingFrequency var1);

        public Builder recordingModeOverrides(Collection<RecordingModeOverride> var1);

        public Builder recordingModeOverrides(RecordingModeOverride ... var1);

        public Builder recordingModeOverrides(Consumer<RecordingModeOverride.Builder> ... var1);
    }
}

