/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;

public class DescribeConfigRulesIterable
implements SdkIterable<DescribeConfigRulesResponse> {
    private final ConfigClient client;
    private final DescribeConfigRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigRulesIterable(ConfigClient client, DescribeConfigRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigRulesResponseFetcher();
    }

    public Iterator<DescribeConfigRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigRule> configRules() {
        Function<DescribeConfigRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configRules() != null) {
                return response.configRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigRulesResponseFetcher
    implements SyncPageFetcher<DescribeConfigRulesResponse> {
        private DescribeConfigRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigRulesResponse nextPage(DescribeConfigRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigRulesIterable.this.client.describeConfigRules(DescribeConfigRulesIterable.this.firstRequest);
            }
            return DescribeConfigRulesIterable.this.client.describeConfigRules((DescribeConfigRulesRequest)((Object)DescribeConfigRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

