/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalEvaluation> {
    private static final SdkField<String> COMPLIANCE_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceResourceType").getter(ExternalEvaluation.getter(ExternalEvaluation::complianceResourceType)).setter(ExternalEvaluation.setter(Builder::complianceResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceType").build()}).build();
    private static final SdkField<String> COMPLIANCE_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceResourceId").getter(ExternalEvaluation.getter(ExternalEvaluation::complianceResourceId)).setter(ExternalEvaluation.setter(Builder::complianceResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceId").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ExternalEvaluation.getter(ExternalEvaluation::complianceTypeAsString)).setter(ExternalEvaluation.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<String> ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Annotation").getter(ExternalEvaluation.getter(ExternalEvaluation::annotation)).setter(ExternalEvaluation.setter(Builder::annotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()}).build();
    private static final SdkField<Instant> ORDERING_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OrderingTimestamp").getter(ExternalEvaluation.getter(ExternalEvaluation::orderingTimestamp)).setter(ExternalEvaluation.setter(Builder::orderingTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_RESOURCE_TYPE_FIELD, COMPLIANCE_RESOURCE_ID_FIELD, COMPLIANCE_TYPE_FIELD, ANNOTATION_FIELD, ORDERING_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String complianceResourceType;
    private final String complianceResourceId;
    private final String complianceType;
    private final String annotation;
    private final Instant orderingTimestamp;

    private ExternalEvaluation(BuilderImpl builder) {
        this.complianceResourceType = builder.complianceResourceType;
        this.complianceResourceId = builder.complianceResourceId;
        this.complianceType = builder.complianceType;
        this.annotation = builder.annotation;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    public final String complianceResourceType() {
        return this.complianceResourceType;
    }

    public final String complianceResourceId() {
        return this.complianceResourceId;
    }

    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final String annotation() {
        return this.annotation;
    }

    public final Instant orderingTimestamp() {
        return this.orderingTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderingTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalEvaluation)) {
            return false;
        }
        ExternalEvaluation other = (ExternalEvaluation)obj;
        return Objects.equals(this.complianceResourceType(), other.complianceResourceType()) && Objects.equals(this.complianceResourceId(), other.complianceResourceId()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.annotation(), other.annotation()) && Objects.equals(this.orderingTimestamp(), other.orderingTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalEvaluation").add("ComplianceResourceType", (Object)this.complianceResourceType()).add("ComplianceResourceId", (Object)this.complianceResourceId()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("Annotation", (Object)this.annotation()).add("OrderingTimestamp", (Object)this.orderingTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceResourceType": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceType()));
            }
            case "ComplianceResourceId": {
                return Optional.ofNullable(clazz.cast(this.complianceResourceId()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "Annotation": {
                return Optional.ofNullable(clazz.cast(this.annotation()));
            }
            case "OrderingTimestamp": {
                return Optional.ofNullable(clazz.cast(this.orderingTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalEvaluation, T> g) {
        return obj -> g.apply((ExternalEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceResourceType;
        private String complianceResourceId;
        private String complianceType;
        private String annotation;
        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalEvaluation model) {
            this.complianceResourceType(model.complianceResourceType);
            this.complianceResourceId(model.complianceResourceId);
            this.complianceType(model.complianceType);
            this.annotation(model.annotation);
            this.orderingTimestamp(model.orderingTimestamp);
        }

        public final String getComplianceResourceType() {
            return this.complianceResourceType;
        }

        public final void setComplianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
        }

        @Override
        public final Builder complianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
            return this;
        }

        public final String getComplianceResourceId() {
            return this.complianceResourceId;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final Instant getOrderingTimestamp() {
            return this.orderingTimestamp;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public ExternalEvaluation build() {
            return new ExternalEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalEvaluation> {
        public Builder complianceResourceType(String var1);

        public Builder complianceResourceId(String var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder annotation(String var1);

        public Builder orderingTimestamp(Instant var1);
    }
}

