/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordingFrequency {
    CONTINUOUS("CONTINUOUS"),
    DAILY("DAILY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordingFrequency> VALUE_MAP;
    private final String value;

    private RecordingFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordingFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordingFrequency> knownValues() {
        EnumSet<RecordingFrequency> knownValues = EnumSet.allOf(RecordingFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordingFrequency.class, RecordingFrequency::toString);
    }
}

