/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ResourceIdentifier;

public class ListDiscoveredResourcesPublisher
implements SdkPublisher<ListDiscoveredResourcesResponse> {
    private final ConfigAsyncClient client;
    private final ListDiscoveredResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDiscoveredResourcesPublisher(ConfigAsyncClient client, ListDiscoveredResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDiscoveredResourcesPublisher(ConfigAsyncClient client, ListDiscoveredResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDiscoveredResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDiscoveredResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceIdentifier> resourceIdentifiers() {
        Function<ListDiscoveredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDiscoveredResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDiscoveredResourcesResponseFetcher
    implements AsyncPageFetcher<ListDiscoveredResourcesResponse> {
        private ListDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDiscoveredResourcesResponse> nextPage(ListDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredResourcesPublisher.this.client.listDiscoveredResources(ListDiscoveredResourcesPublisher.this.firstRequest);
            }
            return ListDiscoveredResourcesPublisher.this.client.listDiscoveredResources((ListDiscoveredResourcesRequest)((Object)ListDiscoveredResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

