/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.ConfigClientBuilder;
import software.amazon.awssdk.services.config.ConfigServiceClientConfiguration;
import software.amazon.awssdk.services.config.DefaultConfigBaseClientBuilder;
import software.amazon.awssdk.services.config.DefaultConfigClient;
import software.amazon.awssdk.services.config.endpoints.ConfigEndpointProvider;

@SdkInternalApi
final class DefaultConfigClientBuilder
extends DefaultConfigBaseClientBuilder<ConfigClientBuilder, ConfigClient>
implements ConfigClientBuilder {
    DefaultConfigClientBuilder() {
    }

    @Override
    public DefaultConfigClientBuilder endpointProvider(ConfigEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConfigClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultConfigClientBuilder.validateClientOptions(clientConfiguration);
        ConfigServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConfigClient client = new DefaultConfigClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConfigServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConfigServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

