/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.ConformancePackDetail;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;

public class DescribeConformancePacksPublisher
implements SdkPublisher<DescribeConformancePacksResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConformancePacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConformancePacksPublisher(ConfigAsyncClient client, DescribeConformancePacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConformancePacksPublisher(ConfigAsyncClient client, DescribeConformancePacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConformancePacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConformancePacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConformancePackDetail> conformancePackDetails() {
        Function<DescribeConformancePacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.conformancePackDetails() != null) {
                return response.conformancePackDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeConformancePacksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeConformancePacksResponseFetcher
    implements AsyncPageFetcher<DescribeConformancePacksResponse> {
        private DescribeConformancePacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConformancePacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConformancePacksResponse> nextPage(DescribeConformancePacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeConformancePacksPublisher.this.client.describeConformancePacks(DescribeConformancePacksPublisher.this.firstRequest);
            }
            return DescribeConformancePacksPublisher.this.client.describeConformancePacks((DescribeConformancePacksRequest)((Object)DescribeConformancePacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

