/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ComplianceTypesCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceDetailsByConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(GetComplianceDetailsByConfigRuleRequest.getter(GetComplianceDetailsByConfigRuleRequest::configRuleName)).setter(GetComplianceDetailsByConfigRuleRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<List<String>> COMPLIANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceTypes").getter(GetComplianceDetailsByConfigRuleRequest.getter(GetComplianceDetailsByConfigRuleRequest::complianceTypesAsStrings)).setter(GetComplianceDetailsByConfigRuleRequest.setter(Builder::complianceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(GetComplianceDetailsByConfigRuleRequest.getter(GetComplianceDetailsByConfigRuleRequest::limit)).setter(GetComplianceDetailsByConfigRuleRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetComplianceDetailsByConfigRuleRequest.getter(GetComplianceDetailsByConfigRuleRequest::nextToken)).setter(GetComplianceDetailsByConfigRuleRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, COMPLIANCE_TYPES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String configRuleName;
    private final List<String> complianceTypes;
    private final Integer limit;
    private final String nextToken;

    private GetComplianceDetailsByConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final List<ComplianceType> complianceTypes() {
        return ComplianceTypesCopier.copyStringToEnum(this.complianceTypes);
    }

    public final boolean hasComplianceTypes() {
        return this.complianceTypes != null && !(this.complianceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> complianceTypesAsStrings() {
        return this.complianceTypes;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByConfigRuleRequest)) {
            return false;
        }
        GetComplianceDetailsByConfigRuleRequest other = (GetComplianceDetailsByConfigRuleRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && this.hasComplianceTypes() == other.hasComplianceTypes() && Objects.equals(this.complianceTypesAsStrings(), other.complianceTypesAsStrings()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetComplianceDetailsByConfigRuleRequest").add("ConfigRuleName", (Object)this.configRuleName()).add("ComplianceTypes", this.hasComplianceTypes() ? this.complianceTypesAsStrings() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ComplianceTypes": {
                return Optional.ofNullable(clazz.cast(this.complianceTypesAsStrings()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByConfigRuleRequest, T> g) {
        return obj -> g.apply((GetComplianceDetailsByConfigRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<String> complianceTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByConfigRuleRequest model) {
            super(model);
            this.configRuleName(model.configRuleName);
            this.complianceTypesWithStrings(model.complianceTypes);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final Collection<String> getComplianceTypes() {
            if (this.complianceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceTypes;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        @Override
        public final Builder complianceTypesWithStrings(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypesWithStrings(String ... complianceTypes) {
            this.complianceTypesWithStrings(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        public final Builder complianceTypes(Collection<ComplianceType> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copyEnumToString(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType ... complianceTypes) {
            this.complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceDetailsByConfigRuleRequest build() {
            return new GetComplianceDetailsByConfigRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceDetailsByConfigRuleRequest> {
        public Builder configRuleName(String var1);

        public Builder complianceTypesWithStrings(Collection<String> var1);

        public Builder complianceTypesWithStrings(String ... var1);

        public Builder complianceTypes(Collection<ComplianceType> var1);

        public Builder complianceTypes(ComplianceType ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

