/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePack;

public class DescribeOrganizationConformancePacksPublisher
implements SdkPublisher<DescribeOrganizationConformancePacksResponse> {
    private final ConfigAsyncClient client;
    private final DescribeOrganizationConformancePacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrganizationConformancePacksPublisher(ConfigAsyncClient client, DescribeOrganizationConformancePacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrganizationConformancePacksPublisher(ConfigAsyncClient client, DescribeOrganizationConformancePacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrganizationConformancePacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrganizationConformancePacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationConformancePack> organizationConformancePacks() {
        Function<DescribeOrganizationConformancePacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConformancePacks() != null) {
                return response.organizationConformancePacks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrganizationConformancePacksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOrganizationConformancePacksResponseFetcher
    implements AsyncPageFetcher<DescribeOrganizationConformancePacksResponse> {
        private DescribeOrganizationConformancePacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConformancePacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOrganizationConformancePacksResponse> nextPage(DescribeOrganizationConformancePacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConformancePacksPublisher.this.client.describeOrganizationConformancePacks(DescribeOrganizationConformancePacksPublisher.this.firstRequest);
            }
            return DescribeOrganizationConformancePacksPublisher.this.client.describeOrganizationConformancePacks((DescribeOrganizationConformancePacksRequest)((Object)DescribeOrganizationConformancePacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

