/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;

public class SelectResourceConfigPublisher
implements SdkPublisher<SelectResourceConfigResponse> {
    private final ConfigAsyncClient client;
    private final SelectResourceConfigRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SelectResourceConfigPublisher(ConfigAsyncClient client, SelectResourceConfigRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SelectResourceConfigPublisher(ConfigAsyncClient client, SelectResourceConfigRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SelectResourceConfigResponseFetcher();
    }

    public void subscribe(Subscriber<? super SelectResourceConfigResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> results() {
        Function<SelectResourceConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SelectResourceConfigResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SelectResourceConfigResponseFetcher
    implements AsyncPageFetcher<SelectResourceConfigResponse> {
        private SelectResourceConfigResponseFetcher() {
        }

        public boolean hasNextPage(SelectResourceConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SelectResourceConfigResponse> nextPage(SelectResourceConfigResponse previousPage) {
            if (previousPage == null) {
                return SelectResourceConfigPublisher.this.client.selectResourceConfig(SelectResourceConfigPublisher.this.firstRequest);
            }
            return SelectResourceConfigPublisher.this.client.selectResourceConfig((SelectResourceConfigRequest)((Object)SelectResourceConfigPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

