/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;

public class GetDiscoveredResourceCountsPublisher
implements SdkPublisher<GetDiscoveredResourceCountsResponse> {
    private final ConfigAsyncClient client;
    private final GetDiscoveredResourceCountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDiscoveredResourceCountsPublisher(ConfigAsyncClient client, GetDiscoveredResourceCountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDiscoveredResourceCountsPublisher(ConfigAsyncClient client, GetDiscoveredResourceCountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDiscoveredResourceCountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDiscoveredResourceCountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetDiscoveredResourceCountsResponseFetcher
    implements AsyncPageFetcher<GetDiscoveredResourceCountsResponse> {
        private GetDiscoveredResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetDiscoveredResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDiscoveredResourceCountsResponse> nextPage(GetDiscoveredResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetDiscoveredResourceCountsPublisher.this.client.getDiscoveredResourceCounts(GetDiscoveredResourceCountsPublisher.this.firstRequest);
            }
            return GetDiscoveredResourceCountsPublisher.this.client.getDiscoveredResourceCounts((GetDiscoveredResourceCountsRequest)((Object)GetDiscoveredResourceCountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

