/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.services.config.model.ControlsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackRuleCompliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackRuleCompliance> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(ConformancePackRuleCompliance.getter(ConformancePackRuleCompliance::configRuleName)).setter(ConformancePackRuleCompliance.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ConformancePackRuleCompliance.getter(ConformancePackRuleCompliance::complianceTypeAsString)).setter(ConformancePackRuleCompliance.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<List<String>> CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Controls").getter(ConformancePackRuleCompliance.getter(ConformancePackRuleCompliance::controls)).setter(ConformancePackRuleCompliance.setter(Builder::controls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Controls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, COMPLIANCE_TYPE_FIELD, CONTROLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String complianceType;
    private final List<String> controls;

    private ConformancePackRuleCompliance(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceType = builder.complianceType;
        this.controls = builder.controls;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final boolean hasControls() {
        return this.controls != null && !(this.controls instanceof SdkAutoConstructList);
    }

    public final List<String> controls() {
        return this.controls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControls() ? this.controls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackRuleCompliance)) {
            return false;
        }
        ConformancePackRuleCompliance other = (ConformancePackRuleCompliance)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && this.hasControls() == other.hasControls() && Objects.equals(this.controls(), other.controls());
    }

    public final String toString() {
        return ToString.builder((String)"ConformancePackRuleCompliance").add("ConfigRuleName", (Object)this.configRuleName()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("Controls", this.hasControls() ? this.controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "Controls": {
                return Optional.ofNullable(clazz.cast(this.controls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackRuleCompliance, T> g) {
        return obj -> g.apply((ConformancePackRuleCompliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String complianceType;
        private List<String> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackRuleCompliance model) {
            this.configRuleName(model.configRuleName);
            this.complianceType(model.complianceType);
            this.controls(model.controls);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        @Transient
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final Collection<String> getControls() {
            if (this.controls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controls;
        }

        public final void setControls(Collection<String> controls) {
            this.controls = ControlsListCopier.copy(controls);
        }

        @Override
        @Transient
        public final Builder controls(Collection<String> controls) {
            this.controls = ControlsListCopier.copy(controls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controls(String ... controls) {
            this.controls(Arrays.asList(controls));
            return this;
        }

        public ConformancePackRuleCompliance build() {
            return new ConformancePackRuleCompliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackRuleCompliance> {
        public Builder configRuleName(String var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);

        public Builder controls(Collection<String> var1);

        public Builder controls(String ... var1);
    }
}

