/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ExternalEvaluation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutExternalEvaluationRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutExternalEvaluationRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(PutExternalEvaluationRequest.getter(PutExternalEvaluationRequest::configRuleName)).setter(PutExternalEvaluationRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<ExternalEvaluation> EXTERNAL_EVALUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalEvaluation").getter(PutExternalEvaluationRequest.getter(PutExternalEvaluationRequest::externalEvaluation)).setter(PutExternalEvaluationRequest.setter(Builder::externalEvaluation)).constructor(ExternalEvaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalEvaluation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, EXTERNAL_EVALUATION_FIELD));
    private final String configRuleName;
    private final ExternalEvaluation externalEvaluation;

    private PutExternalEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.externalEvaluation = builder.externalEvaluation;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final ExternalEvaluation externalEvaluation() {
        return this.externalEvaluation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalEvaluation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalEvaluationRequest)) {
            return false;
        }
        PutExternalEvaluationRequest other = (PutExternalEvaluationRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.externalEvaluation(), other.externalEvaluation());
    }

    public final String toString() {
        return ToString.builder((String)"PutExternalEvaluationRequest").add("ConfigRuleName", (Object)this.configRuleName()).add("ExternalEvaluation", (Object)this.externalEvaluation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ExternalEvaluation": {
                return Optional.ofNullable(clazz.cast(this.externalEvaluation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutExternalEvaluationRequest, T> g) {
        return obj -> g.apply((PutExternalEvaluationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configRuleName;
        private ExternalEvaluation externalEvaluation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutExternalEvaluationRequest model) {
            super(model);
            this.configRuleName(model.configRuleName);
            this.externalEvaluation(model.externalEvaluation);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        @Transient
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final ExternalEvaluation.Builder getExternalEvaluation() {
            return this.externalEvaluation != null ? this.externalEvaluation.toBuilder() : null;
        }

        public final void setExternalEvaluation(ExternalEvaluation.BuilderImpl externalEvaluation) {
            this.externalEvaluation = externalEvaluation != null ? externalEvaluation.build() : null;
        }

        @Override
        @Transient
        public final Builder externalEvaluation(ExternalEvaluation externalEvaluation) {
            this.externalEvaluation = externalEvaluation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutExternalEvaluationRequest build() {
            return new PutExternalEvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutExternalEvaluationRequest> {
        public Builder configRuleName(String var1);

        public Builder externalEvaluation(ExternalEvaluation var1);

        default public Builder externalEvaluation(Consumer<ExternalEvaluation.Builder> externalEvaluation) {
            return this.externalEvaluation((ExternalEvaluation)((ExternalEvaluation.Builder)ExternalEvaluation.builder().applyMutation(externalEvaluation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

