/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.RemediationException;
import software.amazon.awssdk.services.config.model.RemediationExceptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedRemediationExceptionBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedRemediationExceptionBatch> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(FailedRemediationExceptionBatch.getter(FailedRemediationExceptionBatch::failureMessage)).setter(FailedRemediationExceptionBatch.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<RemediationException>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedItems").getter(FailedRemediationExceptionBatch.getter(FailedRemediationExceptionBatch::failedItems)).setter(FailedRemediationExceptionBatch.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD, FAILED_ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failureMessage;
    private final List<RemediationException> failedItems;

    private FailedRemediationExceptionBatch(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructList);
    }

    public final List<RemediationException> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRemediationExceptionBatch)) {
            return false;
        }
        FailedRemediationExceptionBatch other = (FailedRemediationExceptionBatch)obj;
        return Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"FailedRemediationExceptionBatch").add("FailureMessage", (Object)this.failureMessage()).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "FailedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedRemediationExceptionBatch, T> g) {
        return obj -> g.apply((FailedRemediationExceptionBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureMessage;
        private List<RemediationException> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRemediationExceptionBatch model) {
            this.failureMessage(model.failureMessage);
            this.failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        @Transient
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<RemediationException.Builder> getFailedItems() {
            List<RemediationException.Builder> result = RemediationExceptionsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Collection<RemediationException.BuilderImpl> failedItems) {
            this.failedItems = RemediationExceptionsCopier.copyFromBuilder(failedItems);
        }

        @Override
        @Transient
        public final Builder failedItems(Collection<RemediationException> failedItems) {
            this.failedItems = RemediationExceptionsCopier.copy(failedItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedItems(RemediationException ... failedItems) {
            this.failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedItems(Consumer<RemediationException.Builder> ... failedItems) {
            this.failedItems(Stream.of(failedItems).map(c -> (RemediationException)((RemediationException.Builder)RemediationException.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FailedRemediationExceptionBatch build() {
            return new FailedRemediationExceptionBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedRemediationExceptionBatch> {
        public Builder failureMessage(String var1);

        public Builder failedItems(Collection<RemediationException> var1);

        public Builder failedItems(RemediationException ... var1);

        public Builder failedItems(Consumer<RemediationException.Builder> ... var1);
    }
}

