/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateResourceIdentifier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceIdentifiersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAggregateResourceConfigRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, BatchGetAggregateResourceConfigRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorName").getter(BatchGetAggregateResourceConfigRequest.getter(BatchGetAggregateResourceConfigRequest::configurationAggregatorName)).setter(BatchGetAggregateResourceConfigRequest.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<List<AggregateResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifiers").getter(BatchGetAggregateResourceConfigRequest.getter(BatchGetAggregateResourceConfigRequest::resourceIdentifiers)).setter(BatchGetAggregateResourceConfigRequest.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, RESOURCE_IDENTIFIERS_FIELD));
    private final String configurationAggregatorName;
    private final List<AggregateResourceIdentifier> resourceIdentifiers;

    private BatchGetAggregateResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.resourceIdentifiers = builder.resourceIdentifiers;
    }

    public final String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public final boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<AggregateResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigRequest)) {
            return false;
        }
        BatchGetAggregateResourceConfigRequest other = (BatchGetAggregateResourceConfigRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && this.hasResourceIdentifiers() == other.hasResourceIdentifiers() && Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAggregateResourceConfigRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("ResourceIdentifiers", this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAggregateResourceConfigRequest, T> g) {
        return obj -> g.apply((BatchGetAggregateResourceConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private List<AggregateResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAggregateResourceConfigRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.resourceIdentifiers(model.resourceIdentifiers);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        @Transient
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final List<AggregateResourceIdentifier.Builder> getResourceIdentifiers() {
            List<AggregateResourceIdentifier.Builder> result = ResourceIdentifiersListCopier.copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        @Transient
        public final Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceIdentifiers(AggregateResourceIdentifier ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... resourceIdentifiers) {
            this.resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> (AggregateResourceIdentifier)((AggregateResourceIdentifier.Builder)AggregateResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAggregateResourceConfigRequest build() {
            return new BatchGetAggregateResourceConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAggregateResourceConfigRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> var1);

        public Builder resourceIdentifiers(AggregateResourceIdentifier ... var1);

        public Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

