/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.config.model.ConfigurationItemStatus;
import software.amazon.awssdk.services.config.model.RelatedEventListCopier;
import software.amazon.awssdk.services.config.model.Relationship;
import software.amazon.awssdk.services.config.model.RelationshipListCopier;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.SupplementaryConfigurationCopier;
import software.amazon.awssdk.services.config.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationItem> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ConfigurationItem.getter(ConfigurationItem::version)).setter(ConfigurationItem.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ConfigurationItem.getter(ConfigurationItem::accountId)).setter(ConfigurationItem.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> CONFIGURATION_ITEM_CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("configurationItemCaptureTime").getter(ConfigurationItem.getter(ConfigurationItem::configurationItemCaptureTime)).setter(ConfigurationItem.setter(Builder::configurationItemCaptureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemCaptureTime").build()}).build();
    private static final SdkField<String> CONFIGURATION_ITEM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationItemStatus").getter(ConfigurationItem.getter(ConfigurationItem::configurationItemStatusAsString)).setter(ConfigurationItem.setter(Builder::configurationItemStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemStatus").build()}).build();
    private static final SdkField<String> CONFIGURATION_STATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationStateId").getter(ConfigurationItem.getter(ConfigurationItem::configurationStateId)).setter(ConfigurationItem.setter(Builder::configurationStateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStateId").build()}).build();
    private static final SdkField<String> CONFIGURATION_ITEM_MD5_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationItemMD5Hash").getter(ConfigurationItem.getter(ConfigurationItem::configurationItemMD5Hash)).setter(ConfigurationItem.setter(Builder::configurationItemMD5Hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemMD5Hash").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfigurationItem.getter(ConfigurationItem::arn)).setter(ConfigurationItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ConfigurationItem.getter(ConfigurationItem::resourceTypeAsString)).setter(ConfigurationItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ConfigurationItem.getter(ConfigurationItem::resourceId)).setter(ConfigurationItem.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(ConfigurationItem.getter(ConfigurationItem::resourceName)).setter(ConfigurationItem.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(ConfigurationItem.getter(ConfigurationItem::awsRegion)).setter(ConfigurationItem.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(ConfigurationItem.getter(ConfigurationItem::availabilityZone)).setter(ConfigurationItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Instant> RESOURCE_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resourceCreationTime").getter(ConfigurationItem.getter(ConfigurationItem::resourceCreationTime)).setter(ConfigurationItem.setter(Builder::resourceCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCreationTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ConfigurationItem.getter(ConfigurationItem::tags)).setter(ConfigurationItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RELATED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedEvents").getter(ConfigurationItem.getter(ConfigurationItem::relatedEvents)).setter(ConfigurationItem.setter(Builder::relatedEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Relationship>> RELATIONSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationships").getter(ConfigurationItem.getter(ConfigurationItem::relationships)).setter(ConfigurationItem.setter(Builder::relationships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Relationship::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuration").getter(ConfigurationItem.getter(ConfigurationItem::configuration)).setter(ConfigurationItem.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> SUPPLEMENTARY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("supplementaryConfiguration").getter(ConfigurationItem.getter(ConfigurationItem::supplementaryConfiguration)).setter(ConfigurationItem.setter(Builder::supplementaryConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supplementaryConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, ACCOUNT_ID_FIELD, CONFIGURATION_ITEM_CAPTURE_TIME_FIELD, CONFIGURATION_ITEM_STATUS_FIELD, CONFIGURATION_STATE_ID_FIELD, CONFIGURATION_ITEM_MD5_HASH_FIELD, ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, AWS_REGION_FIELD, AVAILABILITY_ZONE_FIELD, RESOURCE_CREATION_TIME_FIELD, TAGS_FIELD, RELATED_EVENTS_FIELD, RELATIONSHIPS_FIELD, CONFIGURATION_FIELD, SUPPLEMENTARY_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String accountId;
    private final Instant configurationItemCaptureTime;
    private final String configurationItemStatus;
    private final String configurationStateId;
    private final String configurationItemMD5Hash;
    private final String arn;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final String awsRegion;
    private final String availabilityZone;
    private final Instant resourceCreationTime;
    private final Map<String, String> tags;
    private final List<String> relatedEvents;
    private final List<Relationship> relationships;
    private final String configuration;
    private final Map<String, String> supplementaryConfiguration;

    private ConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.configurationItemMD5Hash = builder.configurationItemMD5Hash;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.tags = builder.tags;
        this.relatedEvents = builder.relatedEvents;
        this.relationships = builder.relationships;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
    }

    public final String version() {
        return this.version;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant configurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public final ConfigurationItemStatus configurationItemStatus() {
        return ConfigurationItemStatus.fromValue(this.configurationItemStatus);
    }

    public final String configurationItemStatusAsString() {
        return this.configurationItemStatus;
    }

    public final String configurationStateId() {
        return this.configurationStateId;
    }

    public final String configurationItemMD5Hash() {
        return this.configurationItemMD5Hash;
    }

    public final String arn() {
        return this.arn;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Instant resourceCreationTime() {
        return this.resourceCreationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasRelatedEvents() {
        return this.relatedEvents != null && !(this.relatedEvents instanceof SdkAutoConstructList);
    }

    public final List<String> relatedEvents() {
        return this.relatedEvents;
    }

    public final boolean hasRelationships() {
        return this.relationships != null && !(this.relationships instanceof SdkAutoConstructList);
    }

    public final List<Relationship> relationships() {
        return this.relationships;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final boolean hasSupplementaryConfiguration() {
        return this.supplementaryConfiguration != null && !(this.supplementaryConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> supplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemCaptureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemMD5Hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedEvents() ? this.relatedEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationships() ? this.relationships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupplementaryConfiguration() ? this.supplementaryConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationItem)) {
            return false;
        }
        ConfigurationItem other = (ConfigurationItem)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.configurationItemCaptureTime(), other.configurationItemCaptureTime()) && Objects.equals(this.configurationItemStatusAsString(), other.configurationItemStatusAsString()) && Objects.equals(this.configurationStateId(), other.configurationStateId()) && Objects.equals(this.configurationItemMD5Hash(), other.configurationItemMD5Hash()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.resourceCreationTime(), other.resourceCreationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasRelatedEvents() == other.hasRelatedEvents() && Objects.equals(this.relatedEvents(), other.relatedEvents()) && this.hasRelationships() == other.hasRelationships() && Objects.equals(this.relationships(), other.relationships()) && Objects.equals(this.configuration(), other.configuration()) && this.hasSupplementaryConfiguration() == other.hasSupplementaryConfiguration() && Objects.equals(this.supplementaryConfiguration(), other.supplementaryConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationItem").add("Version", (Object)this.version()).add("AccountId", (Object)this.accountId()).add("ConfigurationItemCaptureTime", (Object)this.configurationItemCaptureTime()).add("ConfigurationItemStatus", (Object)this.configurationItemStatusAsString()).add("ConfigurationStateId", (Object)this.configurationStateId()).add("ConfigurationItemMD5Hash", (Object)this.configurationItemMD5Hash()).add("Arn", (Object)this.arn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("AwsRegion", (Object)this.awsRegion()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ResourceCreationTime", (Object)this.resourceCreationTime()).add("Tags", this.hasTags() ? this.tags() : null).add("RelatedEvents", this.hasRelatedEvents() ? this.relatedEvents() : null).add("Relationships", this.hasRelationships() ? this.relationships() : null).add("Configuration", (Object)this.configuration()).add("SupplementaryConfiguration", this.hasSupplementaryConfiguration() ? this.supplementaryConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "configurationItemCaptureTime": {
                return Optional.ofNullable(clazz.cast(this.configurationItemCaptureTime()));
            }
            case "configurationItemStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationItemStatusAsString()));
            }
            case "configurationStateId": {
                return Optional.ofNullable(clazz.cast(this.configurationStateId()));
            }
            case "configurationItemMD5Hash": {
                return Optional.ofNullable(clazz.cast(this.configurationItemMD5Hash()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "resourceCreationTime": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "relatedEvents": {
                return Optional.ofNullable(clazz.cast(this.relatedEvents()));
            }
            case "relationships": {
                return Optional.ofNullable(clazz.cast(this.relationships()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "supplementaryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.supplementaryConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationItem, T> g) {
        return obj -> g.apply((ConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String accountId;
        private Instant configurationItemCaptureTime;
        private String configurationItemStatus;
        private String configurationStateId;
        private String configurationItemMD5Hash;
        private String arn;
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private String awsRegion;
        private String availabilityZone;
        private Instant resourceCreationTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> relatedEvents = DefaultSdkAutoConstructList.getInstance();
        private List<Relationship> relationships = DefaultSdkAutoConstructList.getInstance();
        private String configuration;
        private Map<String, String> supplementaryConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationItem model) {
            this.version(model.version);
            this.accountId(model.accountId);
            this.configurationItemCaptureTime(model.configurationItemCaptureTime);
            this.configurationItemStatus(model.configurationItemStatus);
            this.configurationStateId(model.configurationStateId);
            this.configurationItemMD5Hash(model.configurationItemMD5Hash);
            this.arn(model.arn);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.awsRegion(model.awsRegion);
            this.availabilityZone(model.availabilityZone);
            this.resourceCreationTime(model.resourceCreationTime);
            this.tags(model.tags);
            this.relatedEvents(model.relatedEvents);
            this.relationships(model.relationships);
            this.configuration(model.configuration);
            this.supplementaryConfiguration(model.supplementaryConfiguration);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Instant getConfigurationItemCaptureTime() {
            return this.configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
            return this;
        }

        public final void setConfigurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
        }

        public final String getConfigurationItemStatus() {
            return this.configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus == null ? null : configurationItemStatus.toString());
            return this;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        public final String getConfigurationStateId() {
            return this.configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        public final String getConfigurationItemMD5Hash() {
            return this.configurationItemMD5Hash;
        }

        @Override
        public final Builder configurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
            return this;
        }

        public final void setConfigurationItemMD5Hash(String configurationItemMD5Hash) {
            this.configurationItemMD5Hash = configurationItemMD5Hash;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getResourceCreationTime() {
            return this.resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
            return this;
        }

        public final void setResourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<String> getRelatedEvents() {
            if (this.relatedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedEvents;
        }

        @Override
        public final Builder relatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(String ... relatedEvents) {
            this.relatedEvents(Arrays.asList(relatedEvents));
            return this;
        }

        public final void setRelatedEvents(Collection<String> relatedEvents) {
            this.relatedEvents = RelatedEventListCopier.copy(relatedEvents);
        }

        public final List<Relationship.Builder> getRelationships() {
            List<Relationship.Builder> result = RelationshipListCopier.copyToBuilder(this.relationships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder relationships(Collection<Relationship> relationships) {
            this.relationships = RelationshipListCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Relationship ... relationships) {
            this.relationships(Arrays.asList(relationships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Consumer<Relationship.Builder> ... relationships) {
            this.relationships(Stream.of(relationships).map(c -> (Relationship)((Relationship.Builder)Relationship.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelationships(Collection<Relationship.BuilderImpl> relationships) {
            this.relationships = RelationshipListCopier.copyFromBuilder(relationships);
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            if (this.supplementaryConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.supplementaryConfiguration;
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        public ConfigurationItem build() {
            return new ConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationItem> {
        public Builder version(String var1);

        public Builder accountId(String var1);

        public Builder configurationItemCaptureTime(Instant var1);

        public Builder configurationItemStatus(String var1);

        public Builder configurationItemStatus(ConfigurationItemStatus var1);

        public Builder configurationStateId(String var1);

        public Builder configurationItemMD5Hash(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder awsRegion(String var1);

        public Builder availabilityZone(String var1);

        public Builder resourceCreationTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder relatedEvents(Collection<String> var1);

        public Builder relatedEvents(String ... var1);

        public Builder relationships(Collection<Relationship> var1);

        public Builder relationships(Relationship ... var1);

        public Builder relationships(Consumer<Relationship.Builder> ... var1);

        public Builder configuration(String var1);

        public Builder supplementaryConfiguration(Map<String, String> var1);
    }
}

