/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.BaseConfigurationItem;
import software.amazon.awssdk.services.config.model.BaseConfigurationItemsCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetResourceConfigResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, BatchGetResourceConfigResponse> {
    private static final SdkField<List<BaseConfigurationItem>> BASE_CONFIGURATION_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("baseConfigurationItems").getter(BatchGetResourceConfigResponse.getter(BatchGetResourceConfigResponse::baseConfigurationItems)).setter(BatchGetResourceConfigResponse.setter(Builder::baseConfigurationItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseConfigurationItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BaseConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceKey>> UNPROCESSED_RESOURCE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unprocessedResourceKeys").getter(BatchGetResourceConfigResponse.getter(BatchGetResourceConfigResponse::unprocessedResourceKeys)).setter(BatchGetResourceConfigResponse.setter(Builder::unprocessedResourceKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedResourceKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CONFIGURATION_ITEMS_FIELD, UNPROCESSED_RESOURCE_KEYS_FIELD));
    private final List<BaseConfigurationItem> baseConfigurationItems;
    private final List<ResourceKey> unprocessedResourceKeys;

    private BatchGetResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceKeys = builder.unprocessedResourceKeys;
    }

    public final boolean hasBaseConfigurationItems() {
        return this.baseConfigurationItems != null && !(this.baseConfigurationItems instanceof SdkAutoConstructList);
    }

    public final List<BaseConfigurationItem> baseConfigurationItems() {
        return this.baseConfigurationItems;
    }

    public final boolean hasUnprocessedResourceKeys() {
        return this.unprocessedResourceKeys != null && !(this.unprocessedResourceKeys instanceof SdkAutoConstructList);
    }

    public final List<ResourceKey> unprocessedResourceKeys() {
        return this.unprocessedResourceKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseConfigurationItems() ? this.baseConfigurationItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedResourceKeys() ? this.unprocessedResourceKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigResponse)) {
            return false;
        }
        BatchGetResourceConfigResponse other = (BatchGetResourceConfigResponse)((Object)obj);
        return this.hasBaseConfigurationItems() == other.hasBaseConfigurationItems() && Objects.equals(this.baseConfigurationItems(), other.baseConfigurationItems()) && this.hasUnprocessedResourceKeys() == other.hasUnprocessedResourceKeys() && Objects.equals(this.unprocessedResourceKeys(), other.unprocessedResourceKeys());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetResourceConfigResponse").add("BaseConfigurationItems", this.hasBaseConfigurationItems() ? this.baseConfigurationItems() : null).add("UnprocessedResourceKeys", this.hasUnprocessedResourceKeys() ? this.unprocessedResourceKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseConfigurationItems": {
                return Optional.ofNullable(clazz.cast(this.baseConfigurationItems()));
            }
            case "unprocessedResourceKeys": {
                return Optional.ofNullable(clazz.cast(this.unprocessedResourceKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetResourceConfigResponse, T> g) {
        return obj -> g.apply((BatchGetResourceConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceKey> unprocessedResourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigResponse model) {
            super(model);
            this.baseConfigurationItems(model.baseConfigurationItems);
            this.unprocessedResourceKeys(model.unprocessedResourceKeys);
        }

        public final List<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            List<BaseConfigurationItem.Builder> result = BaseConfigurationItemsCopier.copyToBuilder(this.baseConfigurationItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem ... baseConfigurationItems) {
            this.baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... baseConfigurationItems) {
            this.baseConfigurationItems(Stream.of(baseConfigurationItems).map(c -> (BaseConfigurationItem)((BaseConfigurationItem.Builder)BaseConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        public final List<ResourceKey.Builder> getUnprocessedResourceKeys() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.unprocessedResourceKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copy(unprocessedResourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(ResourceKey ... unprocessedResourceKeys) {
            this.unprocessedResourceKeys(Arrays.asList(unprocessedResourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder> ... unprocessedResourceKeys) {
            this.unprocessedResourceKeys(Stream.of(unprocessedResourceKeys).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedResourceKeys(Collection<ResourceKey.BuilderImpl> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copyFromBuilder(unprocessedResourceKeys);
        }

        @Override
        public BatchGetResourceConfigResponse build() {
            return new BatchGetResourceConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetResourceConfigResponse> {
        public Builder baseConfigurationItems(Collection<BaseConfigurationItem> var1);

        public Builder baseConfigurationItems(BaseConfigurationItem ... var1);

        public Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder> ... var1);

        public Builder unprocessedResourceKeys(Collection<ResourceKey> var1);

        public Builder unprocessedResourceKeys(ResourceKey ... var1);

        public Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder> ... var1);
    }
}

