/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePendingAggregationRequestRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DeletePendingAggregationRequestRequest> {
    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAccountId").getter(DeletePendingAggregationRequestRequest.getter(DeletePendingAggregationRequestRequest::requesterAccountId)).setter(DeletePendingAggregationRequestRequest.setter(Builder::requesterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build()}).build();
    private static final SdkField<String> REQUESTER_AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAwsRegion").getter(DeletePendingAggregationRequestRequest.getter(DeletePendingAggregationRequestRequest::requesterAwsRegion)).setter(DeletePendingAggregationRequestRequest.setter(Builder::requesterAwsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAwsRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTER_ACCOUNT_ID_FIELD, REQUESTER_AWS_REGION_FIELD));
    private final String requesterAccountId;
    private final String requesterAwsRegion;

    private DeletePendingAggregationRequestRequest(BuilderImpl builder) {
        super(builder);
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    public final String requesterAccountId() {
        return this.requesterAccountId;
    }

    public final String requesterAwsRegion() {
        return this.requesterAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAwsRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePendingAggregationRequestRequest)) {
            return false;
        }
        DeletePendingAggregationRequestRequest other = (DeletePendingAggregationRequestRequest)((Object)obj);
        return Objects.equals(this.requesterAccountId(), other.requesterAccountId()) && Objects.equals(this.requesterAwsRegion(), other.requesterAwsRegion());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePendingAggregationRequestRequest").add("RequesterAccountId", (Object)this.requesterAccountId()).add("RequesterAwsRegion", (Object)this.requesterAwsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.requesterAccountId()));
            }
            case "RequesterAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.requesterAwsRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePendingAggregationRequestRequest, T> g) {
        return obj -> g.apply((DeletePendingAggregationRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String requesterAccountId;
        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePendingAggregationRequestRequest model) {
            super(model);
            this.requesterAccountId(model.requesterAccountId);
            this.requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return this.requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        public final String getRequesterAwsRegion() {
            return this.requesterAwsRegion;
        }

        @Override
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePendingAggregationRequestRequest build() {
            return new DeletePendingAggregationRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePendingAggregationRequestRequest> {
        public Builder requesterAccountId(String var1);

        public Builder requesterAwsRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

