/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.MemberAccountStatus;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleDetailedStatusCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOrganizationConfigRuleDetailedStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetOrganizationConfigRuleDetailedStatusResponse> {
    private static final SdkField<List<MemberAccountStatus>> ORGANIZATION_CONFIG_RULE_DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRuleDetailedStatus").getter(GetOrganizationConfigRuleDetailedStatusResponse.getter(GetOrganizationConfigRuleDetailedStatusResponse::organizationConfigRuleDetailedStatus)).setter(GetOrganizationConfigRuleDetailedStatusResponse.setter(Builder::organizationConfigRuleDetailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleDetailedStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberAccountStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOrganizationConfigRuleDetailedStatusResponse.getter(GetOrganizationConfigRuleDetailedStatusResponse::nextToken)).setter(GetOrganizationConfigRuleDetailedStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_DETAILED_STATUS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MemberAccountStatus> organizationConfigRuleDetailedStatus;
    private final String nextToken;

    private GetOrganizationConfigRuleDetailedStatusResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleDetailedStatus = builder.organizationConfigRuleDetailedStatus;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationConfigRuleDetailedStatus() {
        return this.organizationConfigRuleDetailedStatus != null && !(this.organizationConfigRuleDetailedStatus instanceof SdkAutoConstructList);
    }

    public final List<MemberAccountStatus> organizationConfigRuleDetailedStatus() {
        return this.organizationConfigRuleDetailedStatus;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRuleDetailedStatus() ? this.organizationConfigRuleDetailedStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationConfigRuleDetailedStatusResponse)) {
            return false;
        }
        GetOrganizationConfigRuleDetailedStatusResponse other = (GetOrganizationConfigRuleDetailedStatusResponse)((Object)obj);
        return this.hasOrganizationConfigRuleDetailedStatus() == other.hasOrganizationConfigRuleDetailedStatus() && Objects.equals(this.organizationConfigRuleDetailedStatus(), other.organizationConfigRuleDetailedStatus()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetOrganizationConfigRuleDetailedStatusResponse").add("OrganizationConfigRuleDetailedStatus", this.hasOrganizationConfigRuleDetailedStatus() ? this.organizationConfigRuleDetailedStatus() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleDetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleDetailedStatus()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationConfigRuleDetailedStatusResponse, T> g) {
        return obj -> g.apply((GetOrganizationConfigRuleDetailedStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<MemberAccountStatus> organizationConfigRuleDetailedStatus = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationConfigRuleDetailedStatusResponse model) {
            super(model);
            this.organizationConfigRuleDetailedStatus(model.organizationConfigRuleDetailedStatus);
            this.nextToken(model.nextToken);
        }

        public final Collection<MemberAccountStatus.Builder> getOrganizationConfigRuleDetailedStatus() {
            if (this.organizationConfigRuleDetailedStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConfigRuleDetailedStatus != null ? (Collection)this.organizationConfigRuleDetailedStatus.stream().map(MemberAccountStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConfigRuleDetailedStatus(Collection<MemberAccountStatus> organizationConfigRuleDetailedStatus) {
            this.organizationConfigRuleDetailedStatus = OrganizationConfigRuleDetailedStatusCopier.copy(organizationConfigRuleDetailedStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleDetailedStatus(MemberAccountStatus ... organizationConfigRuleDetailedStatus) {
            this.organizationConfigRuleDetailedStatus(Arrays.asList(organizationConfigRuleDetailedStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleDetailedStatus(Consumer<MemberAccountStatus.Builder> ... organizationConfigRuleDetailedStatus) {
            this.organizationConfigRuleDetailedStatus(Stream.of(organizationConfigRuleDetailedStatus).map(c -> (MemberAccountStatus)((MemberAccountStatus.Builder)MemberAccountStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConfigRuleDetailedStatus(Collection<MemberAccountStatus.BuilderImpl> organizationConfigRuleDetailedStatus) {
            this.organizationConfigRuleDetailedStatus = OrganizationConfigRuleDetailedStatusCopier.copyFromBuilder(organizationConfigRuleDetailedStatus);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOrganizationConfigRuleDetailedStatusResponse build() {
            return new GetOrganizationConfigRuleDetailedStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOrganizationConfigRuleDetailedStatusResponse> {
        public Builder organizationConfigRuleDetailedStatus(Collection<MemberAccountStatus> var1);

        public Builder organizationConfigRuleDetailedStatus(MemberAccountStatus ... var1);

        public Builder organizationConfigRuleDetailedStatus(Consumer<MemberAccountStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

