/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value is either a dynamic (resource) value or a static value. You must select either a dynamic value or a static
 * value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationParameterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationParameterValue.Builder, RemediationParameterValue> {
    private static final SdkField<ResourceValue> RESOURCE_VALUE_FIELD = SdkField
            .<ResourceValue> builder(MarshallingType.SDK_POJO).memberName("ResourceValue")
            .getter(getter(RemediationParameterValue::resourceValue)).setter(setter(Builder::resourceValue))
            .constructor(ResourceValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceValue").build()).build();

    private static final SdkField<StaticValue> STATIC_VALUE_FIELD = SdkField.<StaticValue> builder(MarshallingType.SDK_POJO)
            .memberName("StaticValue").getter(getter(RemediationParameterValue::staticValue))
            .setter(setter(Builder::staticValue)).constructor(StaticValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_VALUE_FIELD,
            STATIC_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceValue resourceValue;

    private final StaticValue staticValue;

    private RemediationParameterValue(BuilderImpl builder) {
        this.resourceValue = builder.resourceValue;
        this.staticValue = builder.staticValue;
    }

    /**
     * <p>
     * The value is dynamic and changes at run-time.
     * </p>
     * 
     * @return The value is dynamic and changes at run-time.
     */
    public final ResourceValue resourceValue() {
        return resourceValue;
    }

    /**
     * <p>
     * The value is static and does not change at run-time.
     * </p>
     * 
     * @return The value is static and does not change at run-time.
     */
    public final StaticValue staticValue() {
        return staticValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceValue());
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationParameterValue)) {
            return false;
        }
        RemediationParameterValue other = (RemediationParameterValue) obj;
        return Objects.equals(resourceValue(), other.resourceValue()) && Objects.equals(staticValue(), other.staticValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationParameterValue").add("ResourceValue", resourceValue())
                .add("StaticValue", staticValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceValue":
            return Optional.ofNullable(clazz.cast(resourceValue()));
        case "StaticValue":
            return Optional.ofNullable(clazz.cast(staticValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationParameterValue, T> g) {
        return obj -> g.apply((RemediationParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationParameterValue> {
        /**
         * <p>
         * The value is dynamic and changes at run-time.
         * </p>
         * 
         * @param resourceValue
         *        The value is dynamic and changes at run-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceValue(ResourceValue resourceValue);

        /**
         * <p>
         * The value is dynamic and changes at run-time.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceValue.Builder} avoiding the need to
         * create one manually via {@link ResourceValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceValue.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceValue(ResourceValue)}.
         * 
         * @param resourceValue
         *        a consumer that will call methods on {@link ResourceValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceValue(ResourceValue)
         */
        default Builder resourceValue(Consumer<ResourceValue.Builder> resourceValue) {
            return resourceValue(ResourceValue.builder().applyMutation(resourceValue).build());
        }

        /**
         * <p>
         * The value is static and does not change at run-time.
         * </p>
         * 
         * @param staticValue
         *        The value is static and does not change at run-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(StaticValue staticValue);

        /**
         * <p>
         * The value is static and does not change at run-time.
         * </p>
         * This is a convenience that creates an instance of the {@link StaticValue.Builder} avoiding the need to create
         * one manually via {@link StaticValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link StaticValue.Builder#build()} is called immediately and its result
         * is passed to {@link #staticValue(StaticValue)}.
         * 
         * @param staticValue
         *        a consumer that will call methods on {@link StaticValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticValue(StaticValue)
         */
        default Builder staticValue(Consumer<StaticValue.Builder> staticValue) {
            return staticValue(StaticValue.builder().applyMutation(staticValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceValue resourceValue;

        private StaticValue staticValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationParameterValue model) {
            resourceValue(model.resourceValue);
            staticValue(model.staticValue);
        }

        public final ResourceValue.Builder getResourceValue() {
            return resourceValue != null ? resourceValue.toBuilder() : null;
        }

        @Override
        public final Builder resourceValue(ResourceValue resourceValue) {
            this.resourceValue = resourceValue;
            return this;
        }

        public final void setResourceValue(ResourceValue.BuilderImpl resourceValue) {
            this.resourceValue = resourceValue != null ? resourceValue.build() : null;
        }

        public final StaticValue.Builder getStaticValue() {
            return staticValue != null ? staticValue.toBuilder() : null;
        }

        @Override
        public final Builder staticValue(StaticValue staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public final void setStaticValue(StaticValue.BuilderImpl staticValue) {
            this.staticValue = staticValue != null ? staticValue.build() : null;
        }

        @Override
        public RemediationParameterValue build() {
            return new RemediationParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
