/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutOrganizationConfigRuleRequest extends ConfigRequest implements
        ToCopyableBuilder<PutOrganizationConfigRuleRequest.Builder, PutOrganizationConfigRuleRequest> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConfigRuleName")
            .getter(getter(PutOrganizationConfigRuleRequest::organizationConfigRuleName))
            .setter(setter(Builder::organizationConfigRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build())
            .build();

    private static final SdkField<OrganizationManagedRuleMetadata> ORGANIZATION_MANAGED_RULE_METADATA_FIELD = SdkField
            .<OrganizationManagedRuleMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationManagedRuleMetadata")
            .getter(getter(PutOrganizationConfigRuleRequest::organizationManagedRuleMetadata))
            .setter(setter(Builder::organizationManagedRuleMetadata))
            .constructor(OrganizationManagedRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationManagedRuleMetadata")
                    .build()).build();

    private static final SdkField<OrganizationCustomRuleMetadata> ORGANIZATION_CUSTOM_RULE_METADATA_FIELD = SdkField
            .<OrganizationCustomRuleMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationCustomRuleMetadata")
            .getter(getter(PutOrganizationConfigRuleRequest::organizationCustomRuleMetadata))
            .setter(setter(Builder::organizationCustomRuleMetadata))
            .constructor(OrganizationCustomRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationCustomRuleMetadata")
                    .build()).build();

    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedAccounts")
            .getter(getter(PutOrganizationConfigRuleRequest::excludedAccounts))
            .setter(setter(Builder::excludedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_MANAGED_RULE_METADATA_FIELD,
            ORGANIZATION_CUSTOM_RULE_METADATA_FIELD, EXCLUDED_ACCOUNTS_FIELD));

    private final String organizationConfigRuleName;

    private final OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

    private final OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

    private final List<String> excludedAccounts;

    private PutOrganizationConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationManagedRuleMetadata = builder.organizationManagedRuleMetadata;
        this.organizationCustomRuleMetadata = builder.organizationCustomRuleMetadata;
        this.excludedAccounts = builder.excludedAccounts;
    }

    /**
     * <p>
     * The name that you assign to an organization config rule.
     * </p>
     * 
     * @return The name that you assign to an organization config rule.
     */
    public final String organizationConfigRuleName() {
        return organizationConfigRuleName;
    }

    /**
     * <p>
     * An <code>OrganizationManagedRuleMetadata</code> object.
     * </p>
     * 
     * @return An <code>OrganizationManagedRuleMetadata</code> object.
     */
    public final OrganizationManagedRuleMetadata organizationManagedRuleMetadata() {
        return organizationManagedRuleMetadata;
    }

    /**
     * <p>
     * An <code>OrganizationCustomRuleMetadata</code> object.
     * </p>
     * 
     * @return An <code>OrganizationCustomRuleMetadata</code> object.
     */
    public final OrganizationCustomRuleMetadata organizationCustomRuleMetadata() {
        return organizationCustomRuleMetadata;
    }

    /**
     * Returns true if the ExcludedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExcludedAccounts() {
        return excludedAccounts != null && !(excludedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A comma-separated list of accounts that you want to exclude from an organization config rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A comma-separated list of accounts that you want to exclude from an organization config rule.
     */
    public final List<String> excludedAccounts() {
        return excludedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationManagedRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(organizationCustomRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedAccounts() ? excludedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOrganizationConfigRuleRequest)) {
            return false;
        }
        PutOrganizationConfigRuleRequest other = (PutOrganizationConfigRuleRequest) obj;
        return Objects.equals(organizationConfigRuleName(), other.organizationConfigRuleName())
                && Objects.equals(organizationManagedRuleMetadata(), other.organizationManagedRuleMetadata())
                && Objects.equals(organizationCustomRuleMetadata(), other.organizationCustomRuleMetadata())
                && hasExcludedAccounts() == other.hasExcludedAccounts()
                && Objects.equals(excludedAccounts(), other.excludedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutOrganizationConfigRuleRequest")
                .add("OrganizationConfigRuleName", organizationConfigRuleName())
                .add("OrganizationManagedRuleMetadata", organizationManagedRuleMetadata())
                .add("OrganizationCustomRuleMetadata", organizationCustomRuleMetadata())
                .add("ExcludedAccounts", hasExcludedAccounts() ? excludedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleName":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleName()));
        case "OrganizationManagedRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationManagedRuleMetadata()));
        case "OrganizationCustomRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationCustomRuleMetadata()));
        case "ExcludedAccounts":
            return Optional.ofNullable(clazz.cast(excludedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutOrganizationConfigRuleRequest, T> g) {
        return obj -> g.apply((PutOrganizationConfigRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutOrganizationConfigRuleRequest> {
        /**
         * <p>
         * The name that you assign to an organization config rule.
         * </p>
         * 
         * @param organizationConfigRuleName
         *        The name that you assign to an organization config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleName(String organizationConfigRuleName);

        /**
         * <p>
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * </p>
         * 
         * @param organizationManagedRuleMetadata
         *        An <code>OrganizationManagedRuleMetadata</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata);

        /**
         * <p>
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationManagedRuleMetadata.Builder}
         * avoiding the need to create one manually via {@link OrganizationManagedRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationManagedRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)}.
         * 
         * @param organizationManagedRuleMetadata
         *        a consumer that will call methods on {@link OrganizationManagedRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)
         */
        default Builder organizationManagedRuleMetadata(
                Consumer<OrganizationManagedRuleMetadata.Builder> organizationManagedRuleMetadata) {
            return organizationManagedRuleMetadata(OrganizationManagedRuleMetadata.builder()
                    .applyMutation(organizationManagedRuleMetadata).build());
        }

        /**
         * <p>
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * </p>
         * 
         * @param organizationCustomRuleMetadata
         *        An <code>OrganizationCustomRuleMetadata</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata);

        /**
         * <p>
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationCustomRuleMetadata.Builder} avoiding
         * the need to create one manually via {@link OrganizationCustomRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationCustomRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)}.
         * 
         * @param organizationCustomRuleMetadata
         *        a consumer that will call methods on {@link OrganizationCustomRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)
         */
        default Builder organizationCustomRuleMetadata(
                Consumer<OrganizationCustomRuleMetadata.Builder> organizationCustomRuleMetadata) {
            return organizationCustomRuleMetadata(OrganizationCustomRuleMetadata.builder()
                    .applyMutation(organizationCustomRuleMetadata).build());
        }

        /**
         * <p>
         * A comma-separated list of accounts that you want to exclude from an organization config rule.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts that you want to exclude from an organization config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(Collection<String> excludedAccounts);

        /**
         * <p>
         * A comma-separated list of accounts that you want to exclude from an organization config rule.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts that you want to exclude from an organization config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(String... excludedAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String organizationConfigRuleName;

        private OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

        private OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutOrganizationConfigRuleRequest model) {
            super(model);
            organizationConfigRuleName(model.organizationConfigRuleName);
            organizationManagedRuleMetadata(model.organizationManagedRuleMetadata);
            organizationCustomRuleMetadata(model.organizationCustomRuleMetadata);
            excludedAccounts(model.excludedAccounts);
        }

        public final String getOrganizationConfigRuleName() {
            return organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final OrganizationManagedRuleMetadata.Builder getOrganizationManagedRuleMetadata() {
            return organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata;
            return this;
        }

        public final void setOrganizationManagedRuleMetadata(
                OrganizationManagedRuleMetadata.BuilderImpl organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata
                    .build() : null;
        }

        public final OrganizationCustomRuleMetadata.Builder getOrganizationCustomRuleMetadata() {
            return organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata;
            return this;
        }

        public final void setOrganizationCustomRuleMetadata(
                OrganizationCustomRuleMetadata.BuilderImpl organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.build()
                    : null;
        }

        public final Collection<String> getExcludedAccounts() {
            if (excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String... excludedAccounts) {
            excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutOrganizationConfigRuleRequest build() {
            return new PutOrganizationConfigRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
