/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The controls that AWS Config uses for executing remediations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionControls implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionControls.Builder, ExecutionControls> {
    private static final SdkField<SsmControls> SSM_CONTROLS_FIELD = SdkField.<SsmControls> builder(MarshallingType.SDK_POJO)
            .memberName("SsmControls").getter(getter(ExecutionControls::ssmControls)).setter(setter(Builder::ssmControls))
            .constructor(SsmControls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmControls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSM_CONTROLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SsmControls ssmControls;

    private ExecutionControls(BuilderImpl builder) {
        this.ssmControls = builder.ssmControls;
    }

    /**
     * <p>
     * A SsmControls object.
     * </p>
     * 
     * @return A SsmControls object.
     */
    public final SsmControls ssmControls() {
        return ssmControls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ssmControls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionControls)) {
            return false;
        }
        ExecutionControls other = (ExecutionControls) obj;
        return Objects.equals(ssmControls(), other.ssmControls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionControls").add("SsmControls", ssmControls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SsmControls":
            return Optional.ofNullable(clazz.cast(ssmControls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionControls, T> g) {
        return obj -> g.apply((ExecutionControls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionControls> {
        /**
         * <p>
         * A SsmControls object.
         * </p>
         * 
         * @param ssmControls
         *        A SsmControls object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmControls(SsmControls ssmControls);

        /**
         * <p>
         * A SsmControls object.
         * </p>
         * This is a convenience that creates an instance of the {@link SsmControls.Builder} avoiding the need to create
         * one manually via {@link SsmControls#builder()}.
         *
         * When the {@link Consumer} completes, {@link SsmControls.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmControls(SsmControls)}.
         * 
         * @param ssmControls
         *        a consumer that will call methods on {@link SsmControls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmControls(SsmControls)
         */
        default Builder ssmControls(Consumer<SsmControls.Builder> ssmControls) {
            return ssmControls(SsmControls.builder().applyMutation(ssmControls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SsmControls ssmControls;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionControls model) {
            ssmControls(model.ssmControls);
        }

        public final SsmControls.Builder getSsmControls() {
            return ssmControls != null ? ssmControls.toBuilder() : null;
        }

        @Override
        public final Builder ssmControls(SsmControls ssmControls) {
            this.ssmControls = ssmControls;
            return this;
        }

        public final void setSsmControls(SsmControls.BuilderImpl ssmControls) {
            this.ssmControls = ssmControls != null ? ssmControls.build() : null;
        }

        @Override
        public ExecutionControls build() {
            return new ExecutionControls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
