/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationExecutionStatusResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeRemediationExecutionStatusResponse.Builder, DescribeRemediationExecutionStatusResponse> {
    private static final SdkField<List<RemediationExecutionStatus>> REMEDIATION_EXECUTION_STATUSES_FIELD = SdkField
            .<List<RemediationExecutionStatus>> builder(MarshallingType.LIST)
            .memberName("RemediationExecutionStatuses")
            .getter(getter(DescribeRemediationExecutionStatusResponse::remediationExecutionStatuses))
            .setter(setter(Builder::remediationExecutionStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationExecutionStatuses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationExecutionStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationExecutionStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRemediationExecutionStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REMEDIATION_EXECUTION_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private final List<RemediationExecutionStatus> remediationExecutionStatuses;

    private final String nextToken;

    private DescribeRemediationExecutionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.remediationExecutionStatuses = builder.remediationExecutionStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RemediationExecutionStatuses property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasRemediationExecutionStatuses() {
        return remediationExecutionStatuses != null && !(remediationExecutionStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of remediation execution statuses objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemediationExecutionStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of remediation execution statuses objects.
     */
    public final List<RemediationExecutionStatus> remediationExecutionStatuses() {
        return remediationExecutionStatuses;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRemediationExecutionStatuses() ? remediationExecutionStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExecutionStatusResponse)) {
            return false;
        }
        DescribeRemediationExecutionStatusResponse other = (DescribeRemediationExecutionStatusResponse) obj;
        return hasRemediationExecutionStatuses() == other.hasRemediationExecutionStatuses()
                && Objects.equals(remediationExecutionStatuses(), other.remediationExecutionStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRemediationExecutionStatusResponse")
                .add("RemediationExecutionStatuses", hasRemediationExecutionStatuses() ? remediationExecutionStatuses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationExecutionStatuses":
            return Optional.ofNullable(clazz.cast(remediationExecutionStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExecutionStatusResponse, T> g) {
        return obj -> g.apply((DescribeRemediationExecutionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationExecutionStatusResponse> {
        /**
         * <p>
         * Returns a list of remediation execution statuses objects.
         * </p>
         * 
         * @param remediationExecutionStatuses
         *        Returns a list of remediation execution statuses objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExecutionStatuses(Collection<RemediationExecutionStatus> remediationExecutionStatuses);

        /**
         * <p>
         * Returns a list of remediation execution statuses objects.
         * </p>
         * 
         * @param remediationExecutionStatuses
         *        Returns a list of remediation execution statuses objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExecutionStatuses(RemediationExecutionStatus... remediationExecutionStatuses);

        /**
         * <p>
         * Returns a list of remediation execution statuses objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationExecutionStatus>.Builder}
         * avoiding the need to create one manually via {@link List<RemediationExecutionStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationExecutionStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #remediationExecutionStatuses(List<RemediationExecutionStatus>)}.
         * 
         * @param remediationExecutionStatuses
         *        a consumer that will call methods on {@link List<RemediationExecutionStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationExecutionStatuses(List<RemediationExecutionStatus>)
         */
        Builder remediationExecutionStatuses(Consumer<RemediationExecutionStatus.Builder>... remediationExecutionStatuses);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<RemediationExecutionStatus> remediationExecutionStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExecutionStatusResponse model) {
            super(model);
            remediationExecutionStatuses(model.remediationExecutionStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<RemediationExecutionStatus.Builder> getRemediationExecutionStatuses() {
            if (remediationExecutionStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return remediationExecutionStatuses != null ? remediationExecutionStatuses.stream()
                    .map(RemediationExecutionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remediationExecutionStatuses(Collection<RemediationExecutionStatus> remediationExecutionStatuses) {
            this.remediationExecutionStatuses = RemediationExecutionStatusesCopier.copy(remediationExecutionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExecutionStatuses(RemediationExecutionStatus... remediationExecutionStatuses) {
            remediationExecutionStatuses(Arrays.asList(remediationExecutionStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExecutionStatuses(
                Consumer<RemediationExecutionStatus.Builder>... remediationExecutionStatuses) {
            remediationExecutionStatuses(Stream.of(remediationExecutionStatuses)
                    .map(c -> RemediationExecutionStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemediationExecutionStatuses(
                Collection<RemediationExecutionStatus.BuilderImpl> remediationExecutionStatuses) {
            this.remediationExecutionStatuses = RemediationExecutionStatusesCopier.copyFromBuilder(remediationExecutionStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRemediationExecutionStatusResponse build() {
            return new DescribeRemediationExecutionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
