/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateComplianceCount implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateComplianceCount.Builder, AggregateComplianceCount> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AggregateComplianceCount::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<ComplianceSummary> COMPLIANCE_SUMMARY_FIELD = SdkField
            .<ComplianceSummary> builder(MarshallingType.SDK_POJO).memberName("ComplianceSummary")
            .getter(getter(AggregateComplianceCount::complianceSummary)).setter(setter(Builder::complianceSummary))
            .constructor(ComplianceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            COMPLIANCE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final ComplianceSummary complianceSummary;

    private AggregateComplianceCount(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.complianceSummary = builder.complianceSummary;
    }

    /**
     * <p>
     * The 12-digit account ID or region based on the GroupByKey value.
     * </p>
     * 
     * @return The 12-digit account ID or region based on the GroupByKey value.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The number of compliant and noncompliant AWS Config rules.
     * </p>
     * 
     * @return The number of compliant and noncompliant AWS Config rules.
     */
    public final ComplianceSummary complianceSummary() {
        return complianceSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceCount)) {
            return false;
        }
        AggregateComplianceCount other = (AggregateComplianceCount) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(complianceSummary(), other.complianceSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateComplianceCount").add("GroupName", groupName())
                .add("ComplianceSummary", complianceSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateComplianceCount, T> g) {
        return obj -> g.apply((AggregateComplianceCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateComplianceCount> {
        /**
         * <p>
         * The 12-digit account ID or region based on the GroupByKey value.
         * </p>
         * 
         * @param groupName
         *        The 12-digit account ID or region based on the GroupByKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The number of compliant and noncompliant AWS Config rules.
         * </p>
         * 
         * @param complianceSummary
         *        The number of compliant and noncompliant AWS Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(ComplianceSummary complianceSummary);

        /**
         * <p>
         * The number of compliant and noncompliant AWS Config rules.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceSummary.Builder} avoiding the need to
         * create one manually via {@link ComplianceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceSummary(ComplianceSummary)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link ComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(ComplianceSummary)
         */
        default Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return complianceSummary(ComplianceSummary.builder().applyMutation(complianceSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceCount model) {
            groupName(model.groupName);
            complianceSummary(model.complianceSummary);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public AggregateComplianceCount build() {
            return new AggregateComplianceCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
