/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.RemediationExecutionStepState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemediationExecutionStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemediationExecutionStep> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RemediationExecutionStep.getter(RemediationExecutionStep::name)).setter(RemediationExecutionStep.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RemediationExecutionStep.getter(RemediationExecutionStep::stateAsString)).setter(RemediationExecutionStep.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(RemediationExecutionStep.getter(RemediationExecutionStep::errorMessage)).setter(RemediationExecutionStep.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(RemediationExecutionStep.getter(RemediationExecutionStep::startTime)).setter(RemediationExecutionStep.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopTime").getter(RemediationExecutionStep.getter(RemediationExecutionStep::stopTime)).setter(RemediationExecutionStep.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD, ERROR_MESSAGE_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String state;
    private final String errorMessage;
    private final Instant startTime;
    private final Instant stopTime;

    private RemediationExecutionStep(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    public String name() {
        return this.name;
    }

    public RemediationExecutionStepState state() {
        return RemediationExecutionStepState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant stopTime() {
        return this.stopTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationExecutionStep)) {
            return false;
        }
        RemediationExecutionStep other = (RemediationExecutionStep)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime());
    }

    public String toString() {
        return ToString.builder((String)"RemediationExecutionStep").add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "StopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationExecutionStep, T> g) {
        return obj -> g.apply((RemediationExecutionStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String state;
        private String errorMessage;
        private Instant startTime;
        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationExecutionStep model) {
            this.name(model.name);
            this.state(model.state);
            this.errorMessage(model.errorMessage);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RemediationExecutionStepState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        public RemediationExecutionStep build() {
            return new RemediationExecutionStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemediationExecutionStep> {
        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(RemediationExecutionStepState var1);

        public Builder errorMessage(String var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);
    }
}

