/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.RemediationException;
import software.amazon.awssdk.services.config.model.RemediationExceptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRemediationExceptionsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeRemediationExceptionsResponse> {
    private static final SdkField<List<RemediationException>> REMEDIATION_EXCEPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemediationExceptions").getter(DescribeRemediationExceptionsResponse.getter(DescribeRemediationExceptionsResponse::remediationExceptions)).setter(DescribeRemediationExceptionsResponse.setter(Builder::remediationExceptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationExceptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRemediationExceptionsResponse.getter(DescribeRemediationExceptionsResponse::nextToken)).setter(DescribeRemediationExceptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_EXCEPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RemediationException> remediationExceptions;
    private final String nextToken;

    private DescribeRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.remediationExceptions = builder.remediationExceptions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRemediationExceptions() {
        return this.remediationExceptions != null && !(this.remediationExceptions instanceof SdkAutoConstructList);
    }

    public List<RemediationException> remediationExceptions() {
        return this.remediationExceptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemediationExceptions() ? this.remediationExceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExceptionsResponse)) {
            return false;
        }
        DescribeRemediationExceptionsResponse other = (DescribeRemediationExceptionsResponse)((Object)obj);
        return this.hasRemediationExceptions() == other.hasRemediationExceptions() && Objects.equals(this.remediationExceptions(), other.remediationExceptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRemediationExceptionsResponse").add("RemediationExceptions", this.hasRemediationExceptions() ? this.remediationExceptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemediationExceptions": {
                return Optional.ofNullable(clazz.cast(this.remediationExceptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((DescribeRemediationExceptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<RemediationException> remediationExceptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExceptionsResponse model) {
            super(model);
            this.remediationExceptions(model.remediationExceptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<RemediationException.Builder> getRemediationExceptions() {
            if (this.remediationExceptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.remediationExceptions != null ? (Collection)this.remediationExceptions.stream().map(RemediationException::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remediationExceptions(Collection<RemediationException> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copy(remediationExceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(RemediationException ... remediationExceptions) {
            this.remediationExceptions(Arrays.asList(remediationExceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(Consumer<RemediationException.Builder> ... remediationExceptions) {
            this.remediationExceptions(Stream.of(remediationExceptions).map(c -> (RemediationException)((RemediationException.Builder)RemediationException.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemediationExceptions(Collection<RemediationException.BuilderImpl> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copyFromBuilder(remediationExceptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRemediationExceptionsResponse build() {
            return new DescribeRemediationExceptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRemediationExceptionsResponse> {
        public Builder remediationExceptions(Collection<RemediationException> var1);

        public Builder remediationExceptions(RemediationException ... var1);

        public Builder remediationExceptions(Consumer<RemediationException.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

