/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConformancePackStatusesRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesRequest> {
    private static final SdkField<List<String>> ORGANIZATION_CONFORMANCE_PACK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConformancePackNames").getter(DescribeOrganizationConformancePackStatusesRequest.getter(DescribeOrganizationConformancePackStatusesRequest::organizationConformancePackNames)).setter(DescribeOrganizationConformancePackStatusesRequest.setter(Builder::organizationConformancePackNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeOrganizationConformancePackStatusesRequest.getter(DescribeOrganizationConformancePackStatusesRequest::limit)).setter(DescribeOrganizationConformancePackStatusesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConformancePackStatusesRequest.getter(DescribeOrganizationConformancePackStatusesRequest::nextToken)).setter(DescribeOrganizationConformancePackStatusesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> organizationConformancePackNames;
    private final Integer limit;
    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackNames = builder.organizationConformancePackNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public boolean hasOrganizationConformancePackNames() {
        return this.organizationConformancePackNames != null && !(this.organizationConformancePackNames instanceof SdkAutoConstructList);
    }

    public List<String> organizationConformancePackNames() {
        return this.organizationConformancePackNames;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConformancePackNames() ? this.organizationConformancePackNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesRequest)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesRequest other = (DescribeOrganizationConformancePackStatusesRequest)((Object)obj);
        return this.hasOrganizationConformancePackNames() == other.hasOrganizationConformancePackNames() && Objects.equals(this.organizationConformancePackNames(), other.organizationConformancePackNames()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrganizationConformancePackStatusesRequest").add("OrganizationConformancePackNames", this.hasOrganizationConformancePackNames() ? this.organizationConformancePackNames() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackNames": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackNames()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> organizationConformancePackNames = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesRequest model) {
            super(model);
            this.organizationConformancePackNames(model.organizationConformancePackNames);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getOrganizationConformancePackNames() {
            if (this.organizationConformancePackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationConformancePackNames;
        }

        @Override
        public final Builder organizationConformancePackNames(Collection<String> organizationConformancePackNames) {
            this.organizationConformancePackNames = OrganizationConformancePackNamesCopier.copy(organizationConformancePackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackNames(String ... organizationConformancePackNames) {
            this.organizationConformancePackNames(Arrays.asList(organizationConformancePackNames));
            return this;
        }

        public final void setOrganizationConformancePackNames(Collection<String> organizationConformancePackNames) {
            this.organizationConformancePackNames = OrganizationConformancePackNamesCopier.copy(organizationConformancePackNames);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesRequest build() {
            return new DescribeOrganizationConformancePackStatusesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesRequest> {
        public Builder organizationConformancePackNames(Collection<String> var1);

        public Builder organizationConformancePackNames(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

